/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MdnDocumentationUtil {
    private static final Logger LOG = Logger.getInstance(MdnDocumentationUtil.class);
    private static final String[] HTTP_PREFIXES = new String[]{"http://", "https://"};
    private static final List<String> VISIBLE_BROWSERS = Arrays.asList("chrome", "chrome_android", "edge", "firefox", "ie", "opera", "safari", "safari_ios");

    @NotNull
    private static String getFormattedCompatibilityData(@Nullable Map data) {
        Map support;
        Object compat;
        Object v0 = compat = data != null ? data.get("__compat") : null;
        if (compat != null && (support = (Map)((Map)compat).get("support")) != null) {
            boolean everywhere = true;
            LinkedHashMap<String, String> versions = new LinkedHashMap<String, String>();
            for (Object key : support.keySet()) {
                String browserId = key.toString();
                if (!VISIBLE_BROWSERS.contains(browserId)) continue;
                Object browserInfos = support.get(key);
                Map browserInfo = (Map)(browserInfos instanceof ArrayList ? ((ArrayList)browserInfos).get(0) : browserInfos);
                Object versionAdded = browserInfo.get("version_added");
                String version2 = versionAdded != null ? versionAdded.toString() : "";
                everywhere &= MdnDocumentationUtil.anyVersion(browserId, version2);
                if (StringUtil.isEmpty((String)version2) || "false".equals(version2)) continue;
                versions.put(browserId, version2);
            }
            if (everywhere) {
                return "";
            }
            StringBuilder result2 = new StringBuilder();
            for (Map.Entry entry : versions.entrySet()) {
                if (result2.length() > 0) {
                    result2.append(", ");
                }
                result2.append(MdnDocumentationUtil.getReadableBrowserName((String)entry.getKey()));
                String version3 = (String)entry.getValue();
                if (MdnDocumentationUtil.anyVersion((String)entry.getKey(), version3)) continue;
                result2.append(" ").append(version3);
            }
            return result2.toString();
        }
        return "";
    }

    private static boolean anyVersion(String browser2, String version2) {
        if (browser2.startsWith("edge") && "12".equals(version2)) {
            return true;
        }
        if (browser2.equals("firefox_android") && "4".equals(version2)) {
            return true;
        }
        if (browser2.equals("chrome_android") && "18".equals(version2)) {
            return true;
        }
        return "true".equals(version2) || "1".equals(version2);
    }

    private static String getReadableBrowserName(String key) {
        if ("webview_android".equals(key)) {
            return "Android WebView";
        }
        if ("safari_ios".equals(key)) {
            return "Safari iOS";
        }
        if ("ie".equals(key)) {
            return "IE";
        }
        if ("samsunginternet_android".equals(key)) {
            return "Samsung Internet";
        }
        return StringUtil.capitalizeWords((String)key.replace('_', ' '), (boolean)true);
    }

    @Nullable
    public static String getMdnUrl(@Nullable Map data) {
        Object compat;
        Object v0 = compat = data != null ? data.get("__compat") : null;
        if (compat != null) {
            Object mdnUrl = ((Map)compat).get("mdn_url");
            return mdnUrl != null ? mdnUrl.toString() : null;
        }
        return null;
    }

    public static boolean isDeprecated(@Nullable Map data) {
        Object status;
        Object compat;
        Object v0 = compat = data != null ? data.get("__compat") : null;
        if (compat != null && (status = ((Map)compat).get("status")) != null) {
            return "true".equals(((Map)status).get("deprecated").toString());
        }
        return false;
    }

    @Nullable
    public static String fetchExternalDocumentation(List<String> docUrls, Supplier<String> defaultDocProducer) {
        String url = null;
        for (String urlCandidate : docUrls) {
            if (!urlCandidate.contains("developer.mozilla.org")) continue;
            url = urlCandidate;
        }
        if (url == null) {
            return null;
        }
        File targetDir = new File(PathManager.getConfigPath(), "mdn");
        File targetFile = new File(targetDir, MdnDocumentationUtil.makeUniqueFileName(url));
        try {
            String text = defaultDocProducer.get();
            if (text == null || !text.contains("<div class='content'>")) {
                if (!targetFile.exists()) {
                    DownloadUtil.downloadAtomically(ProgressManager.getInstance().getProgressIndicator(), url + "?raw&summary", targetFile);
                }
                String content = FileUtil.loadFile((File)targetFile, (Charset)CharsetToolkit.UTF8_CHARSET);
                String mdnDecorated = MdnDocumentationUtil.decorate(MdnDocumentationUtil.fixLinks(content), url);
                if (text == null) {
                    return mdnDecorated;
                }
                int definitionEnd = text.indexOf("</pre></div>");
                assert (definitionEnd > 0);
                return text.substring(0, definitionEnd += "</pre></div>".length()) + "<div class='content'>" + mdnDecorated + "</div>" + (definitionEnd < text.length() ? text.substring(definitionEnd) : "");
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return null;
    }

    private static String decorate(String mdnDoc, String url) {
        return mdnDoc + "<div style='padding-top: 5px'>By <a href='" + url + "$history'>Mozilla Contributors</a>, <a href='http://creativecommons.org/licenses/by-sa/2.5/'>CC BY-SA 2.5</a></div>";
    }

    private static String fixLinks(String s) {
        return s.replaceAll("href=\"/", "href=\"https://developer.mozilla.org/");
    }

    private static String makeUniqueFileName(String filePath) {
        String path = filePath;
        for (String prefix : HTTP_PREFIXES) {
            if (!filePath.contains(prefix)) continue;
            path = filePath.replace(prefix, "http_");
            break;
        }
        return path.replace('/', '_').replace('\\', '_').replace(':', '_');
    }

    @NotNull
    public static String buildDoc(@NotNull String name, @NotNull String description, @Nullable Map mdnCompatData) {
        return MdnDocumentationUtil.buildDoc(name, description, mdnCompatData, null);
    }

    @NotNull
    public static String buildDoc(@NotNull String name, @NotNull String description, @Nullable Map mdnCompatData, @Nullable List<Couple<String>> additionalData) {
        StringBuilder buf = new StringBuilder();
        buf.append("<div class='definition'><pre>").append(name).append("</pre></div>");
        buf.append("<div class='content'>");
        buf.append(StringUtil.capitalize((String)description));
        buf.append("</div>");
        String compatibilityData = MdnDocumentationUtil.getFormattedCompatibilityData(mdnCompatData);
        boolean deprecated = MdnDocumentationUtil.isDeprecated(mdnCompatData);
        if (deprecated || !compatibilityData.isEmpty() || !ContainerUtil.isEmpty(additionalData)) {
            buf.append("<table class='sections'>");
        }
        if (!ContainerUtil.isEmpty(additionalData)) {
            for (Couple<String> entry : additionalData) {
                buf.append("<tr><td valign='top' class='section'><p>").append((String)entry.first);
                buf.append("</td><td valign='top'>").append((String)entry.second);
                buf.append("</td>");
            }
        }
        if (deprecated) {
            buf.append("<tr><td valign='top' class='section'><p>").append("Deprecated");
            buf.append("</td>");
        }
        if (!compatibilityData.isEmpty()) {
            buf.append("<tr><td valign='top' class='section'><p>").append("Supported by:");
            buf.append("</td><td valign='top'>").append(compatibilityData);
            buf.append("</td>");
        }
        if (deprecated || !compatibilityData.isEmpty() || !ContainerUtil.isEmpty(additionalData)) {
            buf.append("</table>");
        }
        return buf.toString();
    }
}

