/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaCatalogConfigurable
implements Configurable {
    @NonNls
    public static final String SETTINGS_JSON_SCHEMA_CATALOG = "settings.json.schema.catalog";
    public static final String JSON_SCHEMA_CATALOG = "Remote JSON Schemas";
    @NotNull
    private final Project myProject;
    private final JBCheckBox myCatalogCheckBox;
    private final JBCheckBox myRemoteCheckBox;
    private final JBCheckBox myPreferRemoteCheckBox;

    public JsonSchemaCatalogConfigurable(@NotNull Project project) {
        this.myProject = project;
        this.myCatalogCheckBox = new JBCheckBox("Use schemastore.org JSON Schema catalog");
        this.myRemoteCheckBox = new JBCheckBox("Allow downloading JSON Schemas from remote sources");
        this.myPreferRemoteCheckBox = new JBCheckBox("Always download the most recent version of schemas");
    }

    @Nullable
    public JComponent createComponent() {
        FormBuilder builder2 = FormBuilder.createFormBuilder();
        builder2.addComponent((JComponent)this.myRemoteCheckBox);
        builder2.addVerticalGap(2);
        this.myRemoteCheckBox.addChangeListener(c -> {
            boolean selected = this.myRemoteCheckBox.isSelected();
            this.myCatalogCheckBox.setEnabled(selected);
            this.myPreferRemoteCheckBox.setEnabled(selected);
            if (!selected) {
                this.myCatalogCheckBox.setSelected(false);
                this.myPreferRemoteCheckBox.setSelected(false);
            }
        });
        JsonSchemaCatalogConfigurable.addWithComment(builder2, this.myCatalogCheckBox, "Schemas will be downloaded and assigned using the <a href=\"http://schemastore.org/json/\">SchemaStore API</a>");
        JsonSchemaCatalogConfigurable.addWithComment(builder2, this.myPreferRemoteCheckBox, "Schemas will always be downloaded from the SchemaStore, even if some of them are bundled with the IDE");
        return JsonSchemaCatalogConfigurable.wrap(builder2.getPanel());
    }

    private static void addWithComment(FormBuilder builder2, JBCheckBox box, String s) {
        builder2.addComponent((JComponent)new ComponentPanelBuilder((JComponent)box).withComment(s).createPanel());
    }

    private static JPanel wrap(JComponent panel2) {
        JBPanel wrapper2 = new JBPanel((LayoutManager)new BorderLayout());
        wrapper2.add((Component)panel2, "North");
        return wrapper2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCatalogCheckBox;
    }

    public void reset() {
        JsonSchemaCatalogProjectConfiguration.MyState state = JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).getState();
        boolean remoteEnabled = state == null || state.myIsRemoteActivityEnabled;
        this.myRemoteCheckBox.setSelected(remoteEnabled);
        this.myCatalogCheckBox.setEnabled(remoteEnabled);
        this.myPreferRemoteCheckBox.setEnabled(remoteEnabled);
        this.myCatalogCheckBox.setSelected(state == null || state.myIsCatalogEnabled);
        this.myPreferRemoteCheckBox.setSelected(state == null || state.myIsPreferRemoteSchemas);
    }

    public boolean isModified() {
        JsonSchemaCatalogProjectConfiguration.MyState state = JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).getState();
        return state == null || state.myIsCatalogEnabled != this.myCatalogCheckBox.isSelected() || state.myIsPreferRemoteSchemas != this.myPreferRemoteCheckBox.isSelected() || state.myIsRemoteActivityEnabled != this.myRemoteCheckBox.isSelected();
    }

    public void apply() throws ConfigurationException {
        JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).setState(this.myCatalogCheckBox.isSelected(), this.myRemoteCheckBox.isSelected(), this.myPreferRemoteCheckBox.isSelected());
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return JSON_SCHEMA_CATALOG;
    }

    @Nullable
    public String getHelpTopic() {
        return SETTINGS_JSON_SCHEMA_CATALOG;
    }
}

