/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.jsonSchema.JsonMappingKind;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsonSchemaMappingsProjectConfiguration", storages={@Storage(value="jsonSchemas.xml")})
public class JsonSchemaMappingsProjectConfiguration
implements PersistentStateComponent<MyState> {
    @NotNull
    private final Project myProject;
    public volatile MyState myState = new MyState();

    @Nullable
    public UserDefinedJsonSchemaConfiguration findMappingBySchemaInfo(JsonSchemaInfo value) {
        for (UserDefinedJsonSchemaConfiguration configuration2 : this.myState.myState.values()) {
            if (!this.areSimilar(value, configuration2)) continue;
            return configuration2;
        }
        return null;
    }

    public boolean areSimilar(JsonSchemaInfo value, UserDefinedJsonSchemaConfiguration configuration2) {
        return Objects.equals(this.normalizePath(value.getUrl(this.myProject)), this.normalizePath(configuration2.getRelativePathToSchema()));
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public String normalizePath(@Nullable String valueUrl) {
        if (valueUrl == null) {
            return null;
        }
        if (StringUtil.contains((CharSequence)valueUrl, (CharSequence)"..")) {
            valueUrl = new File(valueUrl).getAbsolutePath();
        }
        return valueUrl.replace('\\', '/');
    }

    @Nullable
    public UserDefinedJsonSchemaConfiguration findMappingForFile(VirtualFile file2) {
        VirtualFile projectBaseDir = this.myProject.getBaseDir();
        for (UserDefinedJsonSchemaConfiguration configuration2 : this.myState.myState.values()) {
            for (UserDefinedJsonSchemaConfiguration.Item pattern : configuration2.patterns) {
                VirtualFile relativeFile;
                if (pattern.mappingKind != JsonMappingKind.File || !Objects.equals(relativeFile = VfsUtil.findRelativeFile((VirtualFile)projectBaseDir, (String[])pattern.getPathParts()), file2) && !file2.getUrl().equals(pattern.getPath())) continue;
                return configuration2;
            }
        }
        return null;
    }

    public static JsonSchemaMappingsProjectConfiguration getInstance(@NotNull Project project) {
        return (JsonSchemaMappingsProjectConfiguration)ServiceManager.getService((Project)project, JsonSchemaMappingsProjectConfiguration.class);
    }

    public JsonSchemaMappingsProjectConfiguration(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public MyState getState() {
        return this.myState;
    }

    public void schemaFileMoved(@NotNull Project project, @NotNull String oldRelativePath, @NotNull String newRelativePath) {
        Optional<UserDefinedJsonSchemaConfiguration> old = this.myState.myState.values().stream().filter(schema -> FileUtil.pathsEqual((String)schema.getRelativePathToSchema(), (String)oldRelativePath)).findFirst();
        old.ifPresent(configuration2 -> {
            configuration2.setRelativePathToSchema(newRelativePath);
            JsonSchemaService.Impl.get(project).reset();
        });
    }

    public void removeConfiguration(UserDefinedJsonSchemaConfiguration configuration2) {
        for (Map.Entry<String, UserDefinedJsonSchemaConfiguration> entry : this.myState.myState.entrySet()) {
            if (entry.getValue() != configuration2) continue;
            this.myState.myState.remove(entry.getKey());
            return;
        }
    }

    public void addConfiguration(UserDefinedJsonSchemaConfiguration configuration2) {
        String name = configuration2.getName();
        while (this.myState.myState.containsKey(name)) {
            name = name + "1";
        }
        this.myState.myState.put(name, configuration2);
    }

    public Map<String, UserDefinedJsonSchemaConfiguration> getStateMap() {
        return Collections.unmodifiableMap(this.myState.myState);
    }

    public void loadState(@NotNull MyState state) {
        this.myState = state;
        JsonSchemaService.Impl.get(this.myProject).reset();
    }

    public void setState(@NotNull Map<String, UserDefinedJsonSchemaConfiguration> state) {
        this.myState = new MyState(state);
    }

    static class MyState {
        @Tag(value="state")
        @XCollection
        public Map<String, UserDefinedJsonSchemaConfiguration> myState = new TreeMap<String, UserDefinedJsonSchemaConfiguration>();

        MyState() {
        }

        MyState(Map<String, UserDefinedJsonSchemaConfiguration> state) {
            this.myState = state;
        }
    }
}

