/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile oldFile = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (oldFile == null || !(oldFile.getFileType() instanceof LanguageFileType) || !((LanguageFileType)oldFile.getFileType()).getLanguage().isKindOf((Language)JsonLanguage.INSTANCE)) {
            return null;
        }
        final Project project = element.getProject();
        if (project.getBaseDir() == null) {
            return null;
        }
        final String oldRelativePath = VfsUtilCore.getRelativePath((VirtualFile)oldFile, (VirtualFile)project.getBaseDir());
        if (oldRelativePath != null) {
            final JsonSchemaMappingsProjectConfiguration configuration2 = JsonSchemaMappingsProjectConfiguration.getInstance(project);
            return new UndoRefactoringElementAdapter(){

                protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
                    String newRelativePath;
                    VirtualFile newFile = PsiUtilBase.asVirtualFile((PsiElement)element);
                    if (newFile != null && (newRelativePath = VfsUtilCore.getRelativePath((VirtualFile)newFile, (VirtualFile)project.getBaseDir())) != null) {
                        configuration2.schemaFileMoved(project, oldRelativePath, newRelativePath);
                    }
                }
            };
        }
        return null;
    }
}

