/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaVfsListener
extends BulkVirtualFileListenerAdapter {
    public static final Topic<Runnable> JSON_SCHEMA_CHANGED = Topic.create((String)"JsonSchemaVfsListener.Json.Schema.Changed", Runnable.class);
    public static final Topic<Runnable> JSON_DEPS_CHANGED = Topic.create((String)"JsonSchemaVfsListener.Json.Deps.Changed", Runnable.class);

    public static void startListening(@NotNull Project project, @NotNull JsonSchemaService service2, @NotNull MessageBusConnection connection) {
        final MyUpdater updater = new MyUpdater(project, service2);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new JsonSchemaVfsListener(updater));
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeAnyChangeAbstractAdapter(){

            protected void onChange(@Nullable PsiFile file2) {
                if (file2 != null) {
                    updater.onFileChange(file2.getViewProvider().getVirtualFile());
                }
            }
        });
    }

    private JsonSchemaVfsListener(final @NotNull MyUpdater updater) {
        super((VirtualFileListener)new VirtualFileContentsChangedAdapter(){
            @NotNull
            private final MyUpdater myUpdater;
            {
                this.myUpdater = updater;
            }

            protected void onFileChange(@NotNull VirtualFile schemaFile) {
                this.myUpdater.onFileChange(schemaFile);
            }

            protected void onBeforeFileChange(@NotNull VirtualFile schemaFile) {
                this.myUpdater.onFileChange(schemaFile);
            }
        });
    }

    private static class MyUpdater {
        @NotNull
        private final Project myProject;
        private final ZipperUpdater myUpdater;
        @NotNull
        private final JsonSchemaService myService;
        private final Set<VirtualFile> myDirtySchemas = ContainerUtil.newConcurrentSet();
        private final Runnable myRunnable;
        private final ExecutorService myTaskExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"JsonVfsUpdaterExecutor");

        protected MyUpdater(@NotNull Project project, @NotNull JsonSchemaService service2) {
            this.myProject = project;
            this.myUpdater = new ZipperUpdater(200, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
            this.myService = service2;
            this.myRunnable = () -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                HashSet<VirtualFile> scope = new HashSet<VirtualFile>(this.myDirtySchemas);
                if (scope.stream().anyMatch(f -> service2.possiblyHasReference(f.getName()))) {
                    ((Runnable)this.myProject.getMessageBus().syncPublisher(JSON_DEPS_CHANGED)).run();
                }
                this.myDirtySchemas.removeAll(scope);
                if (scope.isEmpty()) {
                    return;
                }
                List finalScope = ContainerUtil.filter(scope, file2 -> this.myService.isApplicableToFile((VirtualFile)file2) && ((JsonSchemaServiceImpl)this.myService).isMappedSchema((VirtualFile)file2, false));
                if (finalScope.isEmpty()) {
                    return;
                }
                if (this.myProject.isDisposed()) {
                    return;
                }
                ((Runnable)this.myProject.getMessageBus().syncPublisher(JSON_SCHEMA_CHANGED)).run();
                DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)project);
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                Editor[] editors = EditorFactory.getInstance().getAllEditors();
                Arrays.stream(editors).filter(editor -> editor instanceof EditorEx).map(editor -> ((EditorEx)editor).getVirtualFile()).filter(file2 -> file2 != null && file2.isValid()).forEach(file2 -> {
                    Collection<VirtualFile> schemaFiles = ((JsonSchemaServiceImpl)this.myService).getSchemasForFile((VirtualFile)file2, false, true);
                    if (schemaFiles.stream().anyMatch(finalScope::contains)) {
                        ReadAction.nonBlocking(() -> Optional.ofNullable(psiManager.findFile(file2)).ifPresent(arg_0 -> ((DaemonCodeAnalyzer)analyzer).restart(arg_0))).submit((Executor)this.myTaskExecutor);
                    }
                });
            };
        }

        protected void onFileChange(@NotNull VirtualFile schemaFile) {
            if ("json".equals(schemaFile.getExtension())) {
                this.myDirtySchemas.add(schemaFile);
                this.myUpdater.queue(this.myRunnable);
            }
        }
    }
}

