/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.util.List;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaProjectSelfProviderFactory
implements JsonSchemaProviderFactory {
    public static final int TOTAL_PROVIDERS = 3;
    private static final String SCHEMA_JSON_FILE_NAME = "schema.json";
    private static final String SCHEMA06_JSON_FILE_NAME = "schema06.json";
    private static final String SCHEMA07_JSON_FILE_NAME = "schema07.json";

    @Override
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        return ContainerUtil.list((Object[])new JsonSchemaFileProvider[]{new MyJsonSchemaFileProvider(project, SCHEMA_JSON_FILE_NAME), new MyJsonSchemaFileProvider(project, SCHEMA06_JSON_FILE_NAME), new MyJsonSchemaFileProvider(project, SCHEMA07_JSON_FILE_NAME)});
    }

    public static class MyJsonSchemaFileProvider
    implements JsonSchemaFileProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final NullableLazyValue<VirtualFile> mySchemaFile;
        @NotNull
        private final String myFileName;

        public boolean isSchemaV4() {
            return JsonSchemaProjectSelfProviderFactory.SCHEMA_JSON_FILE_NAME.equals(this.myFileName);
        }

        public boolean isSchemaV6() {
            return JsonSchemaProjectSelfProviderFactory.SCHEMA06_JSON_FILE_NAME.equals(this.myFileName);
        }

        public boolean isSchemaV7() {
            return JsonSchemaProjectSelfProviderFactory.SCHEMA07_JSON_FILE_NAME.equals(this.myFileName);
        }

        private MyJsonSchemaFileProvider(@NotNull Project project, @NotNull String fileName2) {
            this.myProject = project;
            this.myFileName = fileName2;
            this.mySchemaFile = NullableLazyValue.createValue(() -> JsonSchemaProviderFactory.getResourceFile(JsonSchemaProjectSelfProviderFactory.class, "/jsonSchema/" + fileName2));
        }

        @Override
        public boolean isAvailable(@NotNull VirtualFile file2) {
            if (this.myProject.isDisposed()) {
                return false;
            }
            JsonSchemaService service2 = JsonSchemaService.Impl.get(this.myProject);
            if (!service2.isApplicableToFile(file2)) {
                return false;
            }
            JsonSchemaVersion schemaVersion = service2.getSchemaVersion(file2);
            if (schemaVersion == null) {
                return false;
            }
            switch (schemaVersion) {
                case SCHEMA_4: {
                    return this.isSchemaV4();
                }
                case SCHEMA_6: {
                    return this.isSchemaV6();
                }
                case SCHEMA_7: {
                    return this.isSchemaV7();
                }
            }
            throw new NotImplementedError("Unknown schema version: " + (Object)((Object)schemaVersion));
        }

        @Override
        public JsonSchemaVersion getSchemaVersion() {
            return this.isSchemaV4() ? JsonSchemaVersion.SCHEMA_4 : (this.isSchemaV7() ? JsonSchemaVersion.SCHEMA_7 : JsonSchemaVersion.SCHEMA_6);
        }

        @Override
        @NotNull
        public String getName() {
            return this.myFileName;
        }

        @Override
        @Nullable
        public VirtualFile getSchemaFile() {
            return (VirtualFile)this.mySchemaFile.getValue();
        }

        @Override
        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.schema;
        }

        @Override
        @Nullable
        public String getRemoteSource() {
            switch (this.myFileName) {
                case "schema.json": {
                    return "http://json-schema.org/draft-04/schema";
                }
                case "schema06.json": {
                    return "http://json-schema.org/draft-06/schema";
                }
                case "schema07.json": {
                    return "http://json-schema.org/draft-07/schema";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            switch (this.myFileName) {
                case "schema.json": {
                    return "JSON schema v4";
                }
                case "schema06.json": {
                    return "JSON schema v6";
                }
                case "schema07.json": {
                    return "JSON schema v7";
                }
            }
            return this.getName();
        }
    }
}

