/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderMarker;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaUserDefinedProviderFactory
implements JsonSchemaProviderFactory {
    @Override
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        JsonSchemaMappingsProjectConfiguration configuration2 = JsonSchemaMappingsProjectConfiguration.getInstance(project);
        Map<String, UserDefinedJsonSchemaConfiguration> map2 = configuration2.getStateMap();
        List providers = ContainerUtil.map(map2.values(), schema -> this.createProvider(project, (UserDefinedJsonSchemaConfiguration)schema));
        return providers;
    }

    @NotNull
    public MyProvider createProvider(@NotNull Project project, UserDefinedJsonSchemaConfiguration schema) {
        String relPath = schema.getRelativePathToSchema();
        return new MyProvider(project, schema.getSchemaVersion(), schema.getName(), JsonFileResolver.isHttpPath(relPath) || new File(relPath).isAbsolute() ? relPath : new File(project.getBasePath(), relPath).getAbsolutePath(), schema.getCalculatedPatterns());
    }

    static class MyProvider
    implements JsonSchemaFileProvider,
    JsonSchemaImportedProviderMarker {
        @NotNull
        private final Project myProject;
        @NotNull
        private final JsonSchemaVersion myVersion;
        @NotNull
        private final String myName;
        @NotNull
        private final String myFile;
        private VirtualFile myVirtualFile;
        @NotNull
        private final List<? extends PairProcessor<Project, VirtualFile>> myPatterns;

        MyProvider(@NotNull Project project, @NotNull JsonSchemaVersion version2, @NotNull String name, @NotNull String file2, @NotNull List<? extends PairProcessor<Project, VirtualFile>> patterns) {
            this.myProject = project;
            this.myVersion = version2;
            this.myName = name;
            this.myFile = file2;
            this.myPatterns = patterns;
        }

        @Override
        public JsonSchemaVersion getSchemaVersion() {
            return this.myVersion;
        }

        @Override
        @Nullable
        public VirtualFile getSchemaFile() {
            if (this.myVirtualFile != null && this.myVirtualFile.isValid()) {
                return this.myVirtualFile;
            }
            String path = this.myFile;
            if (JsonFileResolver.isHttpPath(path)) {
                this.myVirtualFile = JsonFileResolver.urlToFile(path);
            } else {
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                this.myVirtualFile = lfs.findFileByPath(this.myFile);
                if (this.myVirtualFile == null) {
                    this.myVirtualFile = lfs.refreshAndFindFileByPath(this.myFile);
                }
            }
            return this.myVirtualFile;
        }

        @Override
        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.userSchema;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Override
        public boolean isAvailable(@NotNull VirtualFile file2) {
            if (this.myPatterns.isEmpty() || file2.isDirectory() || !file2.isValid()) {
                return false;
            }
            return this.myPatterns.stream().anyMatch(processor2 -> processor2.process((Object)this.myProject, (Object)file2));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyProvider provider = (MyProvider)o;
            if (!this.myName.equals(provider.myName)) {
                return false;
            }
            return FileUtil.pathsEqual((String)this.myFile, (String)provider.myFile);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + FileUtil.pathHashCode((String)this.myFile);
            return result2;
        }

        @Override
        @Nullable
        public String getRemoteSource() {
            return JsonFileResolver.isHttpPath(this.myFile) ? this.myFile : null;
        }
    }
}

