/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.jetbrains.jsonSchema.impl.JsonSchemaBaseReference;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonRequiredPropsReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        return new PsiReference[]{new JsonRequiredPropReference((JsonStringLiteral)element)};
    }

    @Nullable
    public static JsonObject findPropertiesObject(PsiElement element) {
        JsonValue value;
        PsiElement parent = JsonRequiredPropsReferenceProvider.getParentSafe(JsonRequiredPropsReferenceProvider.getParentSafe(JsonRequiredPropsReferenceProvider.getParentSafe(element)));
        if (!(parent instanceof JsonObject)) {
            return null;
        }
        Optional<JsonProperty> propertiesProp = ((JsonObject)parent).getPropertyList().stream().filter(p -> "properties".equals(p.getName())).findFirst();
        if (propertiesProp.isPresent() && (value = propertiesProp.get().getValue()) instanceof JsonObject) {
            return (JsonObject)value;
        }
        return null;
    }

    private static PsiElement getParentSafe(@Nullable PsiElement element) {
        return element == null ? null : element.getParent();
    }

    private static class JsonRequiredPropReference
    extends JsonSchemaBaseReference<JsonStringLiteral> {
        JsonRequiredPropReference(JsonStringLiteral element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            JsonObject propertiesObject = JsonRequiredPropsReferenceProvider.findPropertiesObject(this.getElement());
            if (propertiesObject != null) {
                String name = ((JsonStringLiteral)this.getElement()).getValue();
                for (JsonProperty property : propertiesObject.getPropertyList()) {
                    if (!name.equals(property.getName())) continue;
                    return property;
                }
            }
            return null;
        }
    }
}

