/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, true, null);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String forcedPropName = null;
        if (element instanceof FakeDocElement) {
            forcedPropName = ((FakeDocElement)element).myAltName;
            element = ((FakeDocElement)element).myContextElement;
        }
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, false, forcedPropName);
    }

    @Nullable
    public static String findSchemaAndGenerateDoc(PsiElement element, @Nullable PsiElement originalElement, boolean preferShort, @Nullable String forcedPropName) {
        VirtualFile virtualFile;
        if (element instanceof FakePsiElement) {
            return null;
        }
        element = JsonSchemaDocumentationProvider.isWhitespaceOrComment(originalElement) ? element : (PsiElement)ObjectUtils.coalesce((Object)originalElement, (Object)element);
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        JsonSchemaService service2 = JsonSchemaService.Impl.get(element.getProject());
        if (!service2.isApplicableToFile(virtualFile = containingFile.getViewProvider().getVirtualFile())) {
            return null;
        }
        JsonSchemaObject rootSchema = service2.getSchemaObject(containingFile);
        if (rootSchema == null) {
            return null;
        }
        return JsonSchemaDocumentationProvider.generateDoc(element, rootSchema, preferShort, forcedPropName);
    }

    private static boolean isWhitespaceOrComment(@Nullable PsiElement originalElement) {
        return originalElement instanceof PsiWhiteSpace || originalElement instanceof PsiComment;
    }

    @Nullable
    public static String generateDoc(@NotNull PsiElement element, @NotNull JsonSchemaObject rootSchema, boolean preferShort, @Nullable String forcedPropName) {
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(element, rootSchema);
        if (walker == null) {
            return null;
        }
        PsiElement checkable = walker.findElementToCheck(element);
        if (checkable == null) {
            return null;
        }
        JsonPointerPosition position = walker.findPosition(checkable, true);
        if (position == null) {
            return null;
        }
        if (forcedPropName != null) {
            if (JsonSchemaDocumentationProvider.isWhitespaceOrComment(element)) {
                position.addFollowingStep(forcedPropName);
            } else {
                if (position.isEmpty()) {
                    return null;
                }
                if (position.isArray(position.size() - 1)) {
                    return null;
                }
                position.replaceStep(position.size() - 1, forcedPropName);
            }
        }
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(element.getProject(), rootSchema, position).resolve();
        String htmlDescription = null;
        boolean deprecated = false;
        ArrayList possibleTypes = ContainerUtil.newArrayList();
        for (JsonSchemaObject schema : schemas) {
            if (htmlDescription == null) {
                htmlDescription = JsonSchemaDocumentationProvider.getBestDocumentation(preferShort, schema);
                String message = schema.getDeprecationMessage();
                if (message != null) {
                    htmlDescription = htmlDescription == null ? message : message + "<br/>" + htmlDescription;
                    deprecated = true;
                }
            }
            if (schema.getType() != null && schema.getType() != JsonSchemaType._any) {
                possibleTypes.add(schema.getType());
                continue;
            }
            if (schema.getTypeVariants() != null) {
                possibleTypes.addAll(schema.getTypeVariants());
                continue;
            }
            JsonSchemaType guessedType = schema.guessType();
            if (guessedType == null) continue;
            possibleTypes.add(guessedType);
        }
        return JsonSchemaDocumentationProvider.appendNameTypeAndApi(position, JsonSchemaDocumentationProvider.getThirdPartyApiInfo(element, rootSchema), possibleTypes, htmlDescription, deprecated, preferShort);
    }

    @Nullable
    private static String appendNameTypeAndApi(@NotNull JsonPointerPosition position, @NotNull String apiInfo, @NotNull List<JsonSchemaType> possibleTypes, @Nullable String htmlDescription, boolean deprecated, boolean preferShort) {
        String deprecationComment;
        if (position.size() == 0) {
            return htmlDescription;
        }
        String name = position.getLastName();
        if (name == null) {
            return htmlDescription;
        }
        String type = "";
        String schemaType = JsonSchemaObject.getTypesDescription(false, possibleTypes);
        if (schemaType != null) {
            type = ": " + schemaType;
        }
        String string = deprecationComment = deprecated ? " (deprecated)" : "";
        htmlDescription = preferShort ? "<b>" + name + "</b>" + type + apiInfo + deprecationComment + (htmlDescription == null ? "" : "<br/>" + htmlDescription) : "<div class='definition'><pre>" + name + type + apiInfo + deprecationComment + "</pre></div>" + (htmlDescription == null ? "" : "<div class='content'>" + htmlDescription + "</div>");
        return htmlDescription;
    }

    @NotNull
    private static String getThirdPartyApiInfo(@NotNull PsiElement element, @NotNull JsonSchemaObject rootSchema) {
        String information;
        JsonSchemaService service2 = JsonSchemaService.Impl.get(element.getProject());
        String apiInfo = "";
        JsonSchemaFileProvider provider = service2.getSchemaProvider(rootSchema);
        if (provider != null && (information = provider.getThirdPartyApiInformation()) != null) {
            apiInfo = "&nbsp;&nbsp;<i>(" + information + ")</i>";
        }
        return apiInfo;
    }

    @Nullable
    public static String getBestDocumentation(boolean preferShort, @NotNull JsonSchemaObject schema) {
        String htmlDescription = schema.getHtmlDescription();
        String description = schema.getDescription();
        String title = schema.getTitle();
        if (preferShort && !StringUtil.isEmptyOrSpaces((String)title)) {
            return JsonSchemaDocumentationProvider.plainTextPostProcess(title);
        }
        if (!StringUtil.isEmptyOrSpaces((String)htmlDescription)) {
            String desc = htmlDescription;
            if (!StringUtil.isEmptyOrSpaces((String)title)) {
                desc = JsonSchemaDocumentationProvider.plainTextPostProcess(title) + "<br/>" + desc;
            }
            return desc;
        }
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            String desc = JsonSchemaDocumentationProvider.plainTextPostProcess(description);
            if (!StringUtil.isEmptyOrSpaces((String)title)) {
                desc = JsonSchemaDocumentationProvider.plainTextPostProcess(title) + "<br/>" + desc;
            }
            return desc;
        }
        return null;
    }

    @NotNull
    private static String plainTextPostProcess(@NotNull String text) {
        return StringUtil.escapeXmlEntities((String)text).replace("\\n", "<br/>");
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if ((element instanceof JsonProperty || JsonSchemaDocumentationProvider.isWhitespaceOrComment(element) && element.getParent() instanceof JsonObject) && object instanceof String) {
            return new FakeDocElement(element instanceof JsonProperty ? ((JsonProperty)element).getNameElement() : element, StringUtil.unquoteString((String)((String)object)));
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link2, PsiElement context) {
        return null;
    }

    private static class FakeDocElement
    extends FakePsiElement {
        private final PsiElement myContextElement;
        private final String myAltName;

        private FakeDocElement(PsiElement context, String name) {
            this.myContextElement = context;
            this.myAltName = name;
        }

        public PsiElement getParent() {
            return this.myContextElement;
        }

        @NotNull
        public TextRange getTextRangeInParent() {
            return this.myContextElement.getTextRange().shiftLeft(this.myContextElement.getTextOffset());
        }
    }
}

