/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonFileType;
import com.intellij.json.JsonLexer;
import com.intellij.json.json5.Json5FileType;
import com.intellij.json.json5.Json5Lexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaFileValuesIndex
extends FileBasedIndexExtension<String, String> {
    public static final ID<String, String> INDEX_ID = ID.create((String)"json.file.root.values");
    private static final int VERSION = 5;
    public static final String NULL = "$NULL$";
    private final DataIndexer<String, String, FileContent> myIndexer = new DataIndexer<String, String, FileContent>(){

        @NotNull
        public Map<String, String> map(@NotNull FileContent inputData) {
            return JsonSchemaFileValuesIndex.readTopLevelProps(inputData.getFileType(), inputData.getContentAsText());
        }
    };

    @NotNull
    public ID<String, String> getName() {
        return INDEX_ID;
    }

    @NotNull
    public DataIndexer<String, String, FileContent> getIndexer() {
        return this.myIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<String> getValueExternalizer() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    public int getVersion() {
        return 5;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return file2 -> file2.getFileType() instanceof JsonFileType;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @Nullable
    public static String getCachedValue(Project project, VirtualFile file2, String requestedKey) {
        if (project.isDisposed() || !file2.isValid() || DumbService.isDumb((Project)project)) {
            return NULL;
        }
        List values = FileBasedIndex.getInstance().getValues(INDEX_ID, (Object)requestedKey, GlobalSearchScope.fileScope((Project)project, (VirtualFile)file2));
        if (values.size() == 1) {
            return (String)values.get(0);
        }
        return null;
    }

    @NotNull
    static Map<String, String> readTopLevelProps(@NotNull FileType fileType, @NotNull CharSequence content) {
        if (!(fileType instanceof JsonFileType)) {
            return ContainerUtil.newHashMap();
        }
        FlexAdapter lexer = fileType == Json5FileType.INSTANCE ? new Json5Lexer() : new JsonLexer();
        HashMap map2 = ContainerUtil.newHashMap();
        lexer.start(content);
        int nesting = 0;
        boolean idFound = false;
        boolean obsoleteIdFound = false;
        boolean schemaFound = false;
        while (!(idFound && schemaFound && obsoleteIdFound || lexer.getCurrentPosition().getOffset() >= lexer.getBufferEnd())) {
            IElementType token = lexer.getTokenType();
            if (token == JsonElementTypes.L_CURLY) {
                ++nesting;
            } else if (token == JsonElementTypes.R_CURLY) {
                --nesting;
            } else if (nesting == 1 && (token == JsonElementTypes.DOUBLE_QUOTED_STRING || token == JsonElementTypes.SINGLE_QUOTED_STRING || token == JsonElementTypes.IDENTIFIER)) {
                switch (lexer.getTokenText()) {
                    case "$id": 
                    case "\"$id\"": 
                    case "'$id'": {
                        idFound |= JsonSchemaFileValuesIndex.captureValueIfString((Lexer)lexer, map2, "JsonSchemaIdCache");
                        break;
                    }
                    case "id": 
                    case "\"id\"": 
                    case "'id'": {
                        obsoleteIdFound |= JsonSchemaFileValuesIndex.captureValueIfString((Lexer)lexer, map2, "JsonSchemaObsoleteIdCache");
                        break;
                    }
                    case "$schema": 
                    case "\"$schema\"": 
                    case "'$schema'": {
                        schemaFound |= JsonSchemaFileValuesIndex.captureValueIfString((Lexer)lexer, map2, "JsonSchemaUrlCache");
                    }
                }
            }
            lexer.advance();
        }
        if (!map2.containsKey("JsonSchemaIdCache")) {
            map2.put("JsonSchemaIdCache", NULL);
        }
        if (!map2.containsKey("JsonSchemaObsoleteIdCache")) {
            map2.put("JsonSchemaObsoleteIdCache", NULL);
        }
        if (!map2.containsKey("JsonSchemaUrlCache")) {
            map2.put("JsonSchemaUrlCache", NULL);
        }
        return map2;
    }

    private static boolean captureValueIfString(@NotNull Lexer lexer, @NotNull HashMap<String, String> destMap, @NotNull String key) {
        lexer.advance();
        IElementType token = JsonSchemaFileValuesIndex.skipWhitespacesAndGetTokenType(lexer);
        if (token == JsonElementTypes.COLON) {
            lexer.advance();
            token = JsonSchemaFileValuesIndex.skipWhitespacesAndGetTokenType(lexer);
            if (token == JsonElementTypes.DOUBLE_QUOTED_STRING || token == JsonElementTypes.SINGLE_QUOTED_STRING) {
                String text = lexer.getTokenText();
                destMap.put(key, StringUtil.isEmpty((String)text) ? text : text.substring(1, text.length() - 1));
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static IElementType skipWhitespacesAndGetTokenType(@NotNull Lexer lexer) {
        while (lexer.getTokenType() == TokenType.WHITE_SPACE || lexer.getTokenType() == JsonElementTypes.LINE_COMMENT || lexer.getTokenType() == JsonElementTypes.BLOCK_COMMENT) {
            lexer.advance();
        }
        return lexer.getTokenType();
    }
}

