/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonPointerReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonRequiredPropsReferenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaReferenceContributor
extends PsiReferenceContributor {
    public static final PsiElementPattern.Capture<JsonValue> REF_PATTERN = JsonSchemaReferenceContributor.createPropertyValuePattern("$ref", true, false);
    public static final PsiElementPattern.Capture<JsonValue> SCHEMA_PATTERN = JsonSchemaReferenceContributor.createPropertyValuePattern("$schema", false, true);
    public static final PsiElementPattern.Capture<JsonStringLiteral> REQUIRED_PROP_PATTERN = JsonSchemaReferenceContributor.createRequiredPropPattern();

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(REF_PATTERN, (PsiReferenceProvider)new JsonPointerReferenceProvider(false));
        registrar.registerReferenceProvider(SCHEMA_PATTERN, (PsiReferenceProvider)new JsonPointerReferenceProvider(true));
        registrar.registerReferenceProvider(REQUIRED_PROP_PATTERN, (PsiReferenceProvider)new JsonRequiredPropsReferenceProvider());
    }

    private static PsiElementPattern.Capture<JsonValue> createPropertyValuePattern(final @NotNull String propertyName, final boolean schemaOnly, final boolean rootOnly) {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (element instanceof JsonValue) {
                    JsonValue value = (JsonValue)element;
                    if (schemaOnly && !JsonSchemaService.isSchemaFile(CompletionUtil.getOriginalOrSelf(value.getContainingFile()))) {
                        return false;
                    }
                    JsonProperty property = (JsonProperty)ObjectUtils.tryCast((Object)value.getParent(), JsonProperty.class);
                    if (property != null && property.getValue() == element) {
                        PsiFile file2 = property.getContainingFile();
                        if (rootOnly && (!(file2 instanceof JsonFile) || ((JsonFile)file2).getTopLevelValue() != property.getParent())) {
                            return false;
                        }
                        return propertyName.equals(property.getName());
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    private static PsiElementPattern.Capture<JsonStringLiteral> createRequiredPropPattern() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (!(element instanceof JsonStringLiteral)) {
                    return false;
                }
                if (!JsonSchemaService.isSchemaFile(((JsonStringLiteral)element).getContainingFile())) {
                    return false;
                }
                PsiElement parent = ((JsonStringLiteral)element).getParent();
                if (!(parent instanceof JsonArray)) {
                    return false;
                }
                PsiElement property = parent.getParent();
                if (!(property instanceof JsonProperty)) {
                    return false;
                }
                return "required".equals(((JsonProperty)property).getName());
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }
}

