/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaResolver {
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonSchemaObject mySchema;
    @NotNull
    private final JsonPointerPosition myPosition;

    public JsonSchemaResolver(@NotNull Project project, @NotNull JsonSchemaObject schema, @NotNull JsonPointerPosition position) {
        this.myProject = project;
        this.mySchema = schema;
        this.myPosition = position;
    }

    public JsonSchemaResolver(@NotNull Project project, @NotNull JsonSchemaObject schema) {
        this.myProject = project;
        this.mySchema = schema;
        this.myPosition = new JsonPointerPosition();
    }

    public MatchResult detailedResolve() {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.myProject, this.mySchema, this.myPosition, false);
        return MatchResult.create(node);
    }

    @NotNull
    public Collection<JsonSchemaObject> resolve() {
        MatchResult result2 = this.detailedResolve();
        LinkedList list2 = ContainerUtil.newLinkedList();
        list2.addAll(result2.mySchemas);
        for (Collection<? extends JsonSchemaObject> myExcludingSchema : result2.myExcludingSchemas) {
            list2.addAll(myExcludingSchema);
        }
        return list2;
    }

    @Nullable
    public PsiElement findNavigationTarget(@Nullable PsiElement element) {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.myProject, this.mySchema, this.myPosition, true);
        JsonSchemaObject schema = this.selectSchema(node, element, this.myPosition.isEmpty());
        if (schema == null) {
            return null;
        }
        VirtualFile file2 = JsonSchemaService.Impl.get(this.myProject).resolveSchemaFile(schema);
        if (file2 == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return null;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker((PsiElement)psiFile, schema);
        return walker == null ? null : JsonSchemaResolver.resolvePosition(walker, (PsiElement)psiFile, JsonPointerPosition.parsePointer(schema.getPointer()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static PsiElement resolvePosition(@NotNull JsonLikePsiWalker walker, @Nullable PsiElement element, @NotNull JsonPointerPosition position) {
        PsiElement psiElement;
        PsiElement psiElement2;
        PsiElement psiElement3 = psiElement2 = element instanceof PsiFile ? walker.getRoot((PsiFile)element) : element;
        if (psiElement2 == null) {
            return null;
        }
        JsonValueAdapter value = walker.createValueAdapter(psiElement2);
        while (position != null && !position.isEmpty()) {
            block11: {
                int index;
                if (value instanceof JsonObjectValueAdapter) {
                    String name = position.getFirstName();
                    if (name == null) {
                        return null;
                    }
                    JsonPropertyAdapter property = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value, name);
                    if (property != null) {
                        value = JsonSchemaResolver.getValue(property);
                        if (value == null) {
                            return null;
                        }
                        break block11;
                    } else {
                        JsonPropertyAdapter props = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value, "properties");
                        if (props != null) {
                            value = JsonSchemaResolver.getValue(props);
                            continue;
                        }
                        JsonPropertyAdapter defs = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value, "definitions");
                        if (defs == null) return null;
                        value = JsonSchemaResolver.getValue(defs);
                        continue;
                    }
                }
                if (value instanceof JsonArrayValueAdapter && (index = position.getFirstIndex()) >= 0) {
                    List<JsonValueAdapter> values = ((JsonArrayValueAdapter)value).getElements();
                    if (values.size() <= index) return null;
                    value = values.get(index);
                }
            }
            position = position.skip(1);
        }
        if (value == null) {
            return null;
        }
        PsiElement delegate = value.getDelegate();
        PsiElement propertyNameElement = walker.getPropertyNameElement(delegate.getParent());
        if (propertyNameElement == null) {
            psiElement = delegate;
            return psiElement;
        }
        psiElement = propertyNameElement;
        return psiElement;
    }

    @Nullable
    private static JsonValueAdapter getValue(@NotNull JsonPropertyAdapter property) {
        Collection<JsonValueAdapter> values = property.getValues();
        return values.size() == 1 ? values.iterator().next() : null;
    }

    @Nullable
    private static JsonPropertyAdapter findProperty(@NotNull JsonObjectValueAdapter value, @NotNull String name) {
        List<JsonPropertyAdapter> list2 = value.getPropertyList();
        return list2.stream().filter(p -> name.equals(p.getName())).findFirst().orElse(null);
    }

    @Nullable
    private JsonSchemaObject selectSchema(@NotNull JsonSchemaTreeNode resolveRoot, @Nullable PsiElement element, boolean topLevelSchema) {
        JsonValueAdapter parentAdapter;
        JsonValueAdapter adapter;
        MatchResult matchResult = MatchResult.create(resolveRoot);
        ArrayList<JsonSchemaObject> schemas = new ArrayList<JsonSchemaObject>(matchResult.mySchemas);
        schemas.addAll(matchResult.myExcludingSchemas.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        JsonSchemaObject firstSchema = JsonSchemaResolver.getFirstValidSchema(schemas);
        if (element == null || schemas.size() == 1 || firstSchema == null) {
            return firstSchema;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(element, firstSchema);
        if (walker == null || (adapter = walker.createValueAdapter(element)) == null) {
            return null;
        }
        if (topLevelSchema) {
            parentAdapter = null;
        } else {
            PsiElement parentValue = walker.getParentContainer(element);
            if (parentValue == null || (parentAdapter = walker.createValueAdapter(parentValue)) == null) {
                return null;
            }
        }
        Ref schemaRef = new Ref();
        MatchResult.iterateTree(resolveRoot, (Processor<? super JsonSchemaTreeNode>)((Processor)node -> {
            JsonSchemaTreeNode parent = node.getParent();
            if (node.getSchema() == null || parentAdapter != null && parent != null && parent.isNothing()) {
                return true;
            }
            if (!this.isCorrect(adapter, node.getSchema())) {
                return true;
            }
            if (parentAdapter == null || parent == null || parent.getSchema() == null || parent.isAny() || this.isCorrect(parentAdapter, parent.getSchema())) {
                schemaRef.set((Object)node.getSchema());
                return false;
            }
            return true;
        }));
        return (JsonSchemaObject)schemaRef.get();
    }

    @Nullable
    private static JsonSchemaObject getFirstValidSchema(List<JsonSchemaObject> schemas) {
        return schemas.stream().findFirst().orElse(null);
    }

    private boolean isCorrect(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        JsonSchemaType type = JsonSchemaType.getType(value);
        if (type == null) {
            return true;
        }
        if (!JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(schema, type)) {
            return false;
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, JsonComplianceCheckerOptions.RELAX_ENUM_CHECK);
        checker.checkByScheme(value, schema);
        return checker.isCorrect();
    }
}

