/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogEntry;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.JsonSchemaEnabler;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaService {
    private static final Logger LOG = Logger.getInstance(JsonSchemaServiceImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MyState myState;
    @NotNull
    private final ClearableLazyValue<Set<String>> myBuiltInSchemaIds;
    @NotNull
    private final Set<String> myRefs = ContainerUtil.newConcurrentSet();
    private final AtomicLong myAnyChangeCount = new AtomicLong(0L);
    @NotNull
    private final JsonSchemaCatalogManager myCatalogManager;
    private final ConcurrentList<Runnable> myResetActions = ContainerUtil.createConcurrentList();

    public JsonSchemaServiceImpl(@NotNull Project project) {
        this.myProject = project;
        this.myState = new MyState(() -> this.getProvidersFromFactories(), this.myProject);
        this.myBuiltInSchemaIds = new ClearableLazyValue<Set<String>>(){

            @NotNull
            protected Set<String> compute() {
                return ContainerUtil.map2Set(JsonSchemaServiceImpl.this.myState.getFiles(), f -> JsonCachedValues.getSchemaId(f, JsonSchemaServiceImpl.this.myProject));
            }
        };
        this.myCatalogManager = new JsonSchemaCatalogManager(this.myProject);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(JsonSchemaVfsListener.JSON_SCHEMA_CHANGED, this.myAnyChangeCount::incrementAndGet);
        connection.subscribe(JsonSchemaVfsListener.JSON_DEPS_CHANGED, () -> {
            this.myRefs.clear();
            this.myAnyChangeCount.incrementAndGet();
        });
        JsonSchemaVfsListener.startListening(project, this, connection);
        this.myCatalogManager.startUpdates();
    }

    @NotNull
    private List<JsonSchemaFileProvider> getProvidersFromFactories() {
        ArrayList<JsonSchemaFileProvider> providers = new ArrayList<JsonSchemaFileProvider>();
        for (JsonSchemaProviderFactory factory : this.getProviderFactories()) {
            try {
                providers.addAll(factory.getProviders(this.myProject));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                PluginException.logPluginError((Logger)Logger.getInstance(JsonSchemaService.class), (String)e.getMessage(), (Throwable)e, factory.getClass());
            }
        }
        return providers;
    }

    @NotNull
    protected List<JsonSchemaProviderFactory> getProviderFactories() {
        return JsonSchemaProviderFactory.EP_NAME.getExtensionList();
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull VirtualFile schemaFile) {
        return this.myState.getProvider(schemaFile);
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile file2 = this.resolveSchemaFile(schemaObject);
        return file2 == null ? null : this.getSchemaProvider(file2);
    }

    @Override
    public void reset() {
        this.myState.reset();
        this.myBuiltInSchemaIds.drop();
        this.myAnyChangeCount.incrementAndGet();
        for (Runnable action : this.myResetActions) {
            action.run();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    public VirtualFile findSchemaFileByReference(@NotNull String reference, @Nullable VirtualFile referent) {
        VirtualFile file2 = this.findBuiltInSchemaByReference(reference);
        if (file2 != null) {
            return file2;
        }
        if (reference.startsWith("#")) {
            return referent;
        }
        return JsonFileResolver.resolveSchemaByReference(referent, JsonPointerUtil.normalizeId(reference));
    }

    @Nullable
    private VirtualFile findBuiltInSchemaByReference(@NotNull String reference) {
        String id = JsonPointerUtil.normalizeId(reference);
        if (!((Set)this.myBuiltInSchemaIds.getValue()).contains(id)) {
            return null;
        }
        for (VirtualFile file2 : this.myState.getFiles()) {
            if (!id.equals(JsonCachedValues.getSchemaId(file2, this.myProject))) continue;
            return file2;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSchemaFilesForFile(@NotNull VirtualFile file2) {
        return this.getSchemasForFile(file2, false, false);
    }

    @NotNull
    public Collection<VirtualFile> getSchemasForFile(@NotNull VirtualFile file2, boolean single, boolean onlyUserSchemas) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        String schemaUrl = null;
        if (!onlyUserSchemas && JsonSchemaServiceImpl.isSchemaUrl(schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject)) && (virtualFile2 = this.resolveFromSchemaProperty(schemaUrl, file2)) != null) {
            return Collections.singletonList(virtualFile2);
        }
        List<JsonSchemaFileProvider> providers = this.getProvidersForFile(file2);
        boolean checkSchemaProperty = true;
        if (!onlyUserSchemas && providers.stream().noneMatch(p -> p.getSchemaType() == SchemaType.userSchema)) {
            if (schemaUrl == null) {
                schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject);
            }
            if ((virtualFile = this.resolveFromSchemaProperty(schemaUrl, file2)) != null) {
                return Collections.singletonList(virtualFile);
            }
            checkSchemaProperty = false;
        }
        if (!single) {
            ArrayList files2 = ContainerUtil.newArrayList();
            for (JsonSchemaFileProvider provider2 : providers) {
                VirtualFile schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(this.myProject, provider2);
                if (schemaFile == null) continue;
                files2.add(schemaFile);
            }
            if (!files2.isEmpty()) {
                return files2;
            }
        } else if (!providers.isEmpty()) {
            JsonSchemaFileProvider selected;
            if (providers.size() > 2) {
                return ContainerUtil.emptyList();
            }
            if (providers.size() > 1) {
                Optional<JsonSchemaFileProvider> userSchema = providers.stream().filter(provider -> SchemaType.userSchema.equals((Object)provider.getSchemaType())).findFirst();
                if (!userSchema.isPresent()) {
                    return ContainerUtil.emptyList();
                }
                selected = userSchema.get();
            } else {
                selected = providers.get(0);
            }
            VirtualFile schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(this.myProject, selected);
            return ContainerUtil.createMaybeSingletonList((Object)schemaFile);
        }
        if (onlyUserSchemas) {
            return ContainerUtil.emptyList();
        }
        if (checkSchemaProperty) {
            if (schemaUrl == null) {
                schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject);
            }
            if ((virtualFile = this.resolveFromSchemaProperty(schemaUrl, file2)) != null) {
                return Collections.singletonList(virtualFile);
            }
        }
        return ContainerUtil.createMaybeSingletonList((Object)this.resolveSchemaFromOtherSources(file2));
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProvidersForFile(@NotNull VirtualFile file2) {
        return ContainerUtil.filter(this.myState.getProviders(), provider -> JsonSchemaServiceImpl.isProviderAvailable(file2, provider));
    }

    @Nullable
    private VirtualFile resolveFromSchemaProperty(@Nullable String schemaUrl, @NotNull VirtualFile file2) {
        VirtualFile virtualFile;
        if (schemaUrl != null && (virtualFile = this.findSchemaFileByReference(schemaUrl, file2)) != null) {
            return virtualFile;
        }
        return null;
    }

    @Override
    public List<JsonSchemaInfo> getAllUserVisibleSchemas() {
        JsonSchemaInfo info;
        List<JsonSchemaCatalogEntry> schemas = this.myCatalogManager.getAllCatalogEntries();
        Collection<? extends JsonSchemaFileProvider> providers = this.myState.getProviders();
        ArrayList results = ContainerUtil.newArrayListWithCapacity((int)(schemas.size() + providers.size()));
        HashMap processedRemotes = ContainerUtil.newHashMap();
        for (JsonSchemaFileProvider jsonSchemaFileProvider : providers) {
            if (!jsonSchemaFileProvider.isUserVisible()) continue;
            String remoteSource = jsonSchemaFileProvider.getRemoteSource();
            if (remoteSource != null) {
                if (processedRemotes.containsKey(remoteSource)) continue;
                info = new JsonSchemaInfo(jsonSchemaFileProvider);
                processedRemotes.put(remoteSource, info);
                results.add(info);
                continue;
            }
            results.add(new JsonSchemaInfo(jsonSchemaFileProvider));
        }
        for (JsonSchemaCatalogEntry jsonSchemaCatalogEntry : schemas) {
            String url = jsonSchemaCatalogEntry.getUrl();
            if (!processedRemotes.containsKey(url)) {
                info = new JsonSchemaInfo(url);
                if (jsonSchemaCatalogEntry.getDescription() != null) {
                    info.setDocumentation(jsonSchemaCatalogEntry.getDescription());
                }
                if (jsonSchemaCatalogEntry.getName() != null) {
                    info.setName(jsonSchemaCatalogEntry.getName());
                }
                results.add(info);
                continue;
            }
            info = (JsonSchemaInfo)processedRemotes.get(url);
            if (info.getDocumentation() == null) {
                info.setDocumentation(jsonSchemaCatalogEntry.getDescription());
            }
            if (info.getName() != null) continue;
            info.setName(jsonSchemaCatalogEntry.getName());
        }
        return results;
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull VirtualFile file2) {
        Collection<VirtualFile> schemas = this.getSchemasForFile(file2, true, false);
        if (schemas.size() == 0) {
            return null;
        }
        assert (schemas.size() == 1);
        VirtualFile schemaFile = schemas.iterator().next();
        return JsonCachedValues.getSchemaObject(this.replaceHttpFileWithBuiltinIfNeeded(schemaFile), this.myProject);
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull PsiFile file2) {
        return JsonCachedValues.computeSchemaForFile(file2, this);
    }

    public VirtualFile replaceHttpFileWithBuiltinIfNeeded(VirtualFile schemaFile) {
        if (!JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).isPreferRemoteSchemas() && schemaFile instanceof HttpVirtualFile) {
            String url = schemaFile.getUrl();
            VirtualFile first1 = this.getLocalSchemaByUrl(url);
            return first1 != null ? first1 : schemaFile;
        }
        return schemaFile;
    }

    @Nullable
    public VirtualFile getLocalSchemaByUrl(String url) {
        return this.myState.getFiles().stream().filter(f -> {
            JsonSchemaFileProvider prov = this.getSchemaProvider((VirtualFile)f);
            return prov != null && !(prov.getSchemaFile() instanceof HttpVirtualFile) && (url.equals(prov.getRemoteSource()) || JsonFileResolver.replaceUnsafeSchemaStoreUrls(url).equals(prov.getRemoteSource()) || url.equals(JsonFileResolver.replaceUnsafeSchemaStoreUrls(prov.getRemoteSource())));
        }).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObjectForSchemaFile(@NotNull VirtualFile schemaFile) {
        return JsonCachedValues.getSchemaObject(schemaFile, this.myProject);
    }

    @Override
    public boolean isSchemaFile(@NotNull VirtualFile file2) {
        return this.isMappedSchema(file2) || this.isSchemaByProvider(file2) || this.hasSchemaSchema(file2);
    }

    @Override
    public boolean isSchemaFile(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile file2 = this.resolveSchemaFile(schemaObject);
        return file2 != null && this.isSchemaFile(file2);
    }

    private boolean isMappedSchema(@NotNull VirtualFile file2) {
        return this.isMappedSchema(file2, true);
    }

    public boolean isMappedSchema(@NotNull VirtualFile file2, boolean canRecompute) {
        return (canRecompute || this.myState.isComputed()) && this.myState.getFiles().contains(file2);
    }

    private boolean isSchemaByProvider(@NotNull VirtualFile file2) {
        JsonSchemaFileProvider provider = this.myState.getProvider(file2);
        if (provider == null) {
            for (JsonSchemaFileProvider jsonSchemaFileProvider : this.myState.getProviders()) {
                if (!JsonSchemaServiceImpl.isSchemaProvider(jsonSchemaFileProvider) || !jsonSchemaFileProvider.isAvailable(file2)) continue;
                return true;
            }
            return false;
        }
        return JsonSchemaServiceImpl.isSchemaProvider(provider);
    }

    private static boolean isSchemaProvider(JsonSchemaFileProvider provider) {
        return JsonSchemaServiceImpl.isSchemaUrl(provider.getRemoteSource());
    }

    private static boolean isSchemaUrl(@Nullable String url) {
        return url != null && url.startsWith("http://json-schema.org/") && (url.endsWith("/schema") || url.endsWith("/schema#"));
    }

    @Override
    public JsonSchemaVersion getSchemaVersion(@NotNull VirtualFile file2) {
        JsonSchemaFileProvider provider;
        if (this.isMappedSchema(file2) && (provider = this.myState.getProvider(file2)) != null) {
            return provider.getSchemaVersion();
        }
        return this.getSchemaVersionFromSchemaUrl(file2);
    }

    @Nullable
    private JsonSchemaVersion getSchemaVersionFromSchemaUrl(@NotNull VirtualFile file2) {
        Ref res2 = Ref.create(null);
        ApplicationManager.getApplication().runReadAction(() -> res2.set((Object)JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject)));
        if (res2.isNull()) {
            return null;
        }
        return JsonSchemaVersion.byId((String)res2.get());
    }

    private boolean hasSchemaSchema(VirtualFile file2) {
        return this.getSchemaVersionFromSchemaUrl(file2) != null;
    }

    private static boolean isProviderAvailable(@NotNull VirtualFile file2, @NotNull JsonSchemaFileProvider provider) {
        return provider.isAvailable(file2);
    }

    @Nullable
    private VirtualFile resolveSchemaFromOtherSources(@NotNull VirtualFile file2) {
        return this.myCatalogManager.getSchemaFileForFile(file2);
    }

    @Override
    public void registerRemoteUpdateCallback(Runnable callback2) {
        this.myCatalogManager.registerCatalogUpdateCallback(callback2);
    }

    @Override
    public void unregisterRemoteUpdateCallback(Runnable callback2) {
        this.myCatalogManager.unregisterCatalogUpdateCallback(callback2);
    }

    @Override
    public void registerResetAction(Runnable action) {
        this.myResetActions.add((Object)action);
    }

    @Override
    public void unregisterResetAction(Runnable action) {
        this.myResetActions.remove((Object)action);
    }

    @Override
    public void registerReference(String ref) {
        int index = StringUtil.lastIndexOfAny((CharSequence)ref, (String)"\\/");
        if (index >= 0) {
            ref = ref.substring(index + 1);
        }
        this.myRefs.add(ref);
    }

    @Override
    public boolean possiblyHasReference(String ref) {
        return this.myRefs.contains(ref);
    }

    @Override
    public void triggerUpdateRemote() {
        this.myCatalogManager.triggerUpdateCatalog(this.myProject);
    }

    @Override
    public boolean isApplicableToFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        for (JsonSchemaEnabler e : JsonSchemaEnabler.EXTENSION_POINT_NAME.getExtensionList()) {
            if (!e.isEnabledForFile(file2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile getSchemaForProvider(@NotNull Project project, @NotNull JsonSchemaFileProvider provider) {
        String source;
        if (JsonSchemaCatalogProjectConfiguration.getInstance(project).isPreferRemoteSchemas() && (source = provider.getRemoteSource()) != null && !source.endsWith("!")) {
            return VirtualFileManager.getInstance().findFileByUrl(source);
        }
        return provider.getSchemaFile();
    }

    @Override
    @Nullable
    public VirtualFile resolveSchemaFile(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile rawFile = schemaObject.getRawFile();
        if (rawFile != null) {
            return rawFile;
        }
        String fileUrl = schemaObject.getFileUrl();
        if (fileUrl == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(fileUrl);
    }

    private static class MyState {
        @NotNull
        private final Factory<List<JsonSchemaFileProvider>> myFactory;
        @NotNull
        private final Project myProject;
        @NotNull
        private final ClearableLazyValue<MultiMap<VirtualFile, JsonSchemaFileProvider>> myData;
        private final AtomicBoolean myIsComputed = new AtomicBoolean(false);

        private MyState(@NotNull Factory<List<JsonSchemaFileProvider>> factory, @NotNull Project project) {
            this.myFactory = factory;
            this.myProject = project;
            this.myData = new ClearableLazyValue<MultiMap<VirtualFile, JsonSchemaFileProvider>>(){

                @NotNull
                public MultiMap<VirtualFile, JsonSchemaFileProvider> compute() {
                    MultiMap map2 = MyState.createFileProviderMap((List)myFactory.create(), myProject);
                    myIsComputed.set(true);
                    return map2;
                }

                @NotNull
                public final synchronized MultiMap<VirtualFile, JsonSchemaFileProvider> getValue() {
                    return (MultiMap)super.getValue();
                }

                public final synchronized void drop() {
                    myIsComputed.set(false);
                    super.drop();
                }
            };
        }

        public void reset() {
            this.myData.drop();
        }

        @NotNull
        public Collection<? extends JsonSchemaFileProvider> getProviders() {
            return ((MultiMap)this.myData.getValue()).values();
        }

        @NotNull
        public Set<VirtualFile> getFiles() {
            return ((MultiMap)this.myData.getValue()).keySet();
        }

        @Nullable
        public JsonSchemaFileProvider getProvider(@NotNull VirtualFile file2) {
            Collection providers = ((MultiMap)this.myData.getValue()).get((Object)file2);
            for (JsonSchemaFileProvider p : providers) {
                if (p.getSchemaType() != SchemaType.userSchema) continue;
                return p;
            }
            return (JsonSchemaFileProvider)ContainerUtil.getFirstItem((Collection)providers);
        }

        public boolean isComputed() {
            return this.myIsComputed.get();
        }

        @NotNull
        private static MultiMap<VirtualFile, JsonSchemaFileProvider> createFileProviderMap(@NotNull List<JsonSchemaFileProvider> list2, @NotNull Project project) {
            MultiMap map2 = MultiMap.create();
            for (JsonSchemaFileProvider provider : list2) {
                VirtualFile schemaFile;
                try {
                    schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(project, provider);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                if (schemaFile == null) continue;
                map2.putValue((Object)schemaFile, (Object)provider);
            }
            return map2;
        }
    }
}

