/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaTreeNode {
    private boolean myAny;
    private boolean myNothing;
    private int myExcludingGroupNumber = -1;
    @NotNull
    private SchemaResolveState myResolveState = SchemaResolveState.normal;
    @Nullable
    private final JsonSchemaObject mySchema;
    @NotNull
    private final JsonPointerPosition myPosition;
    @Nullable
    private final JsonSchemaTreeNode myParent;
    @NotNull
    private final List<JsonSchemaTreeNode> myChildren = new ArrayList<JsonSchemaTreeNode>();

    public JsonSchemaTreeNode(@Nullable JsonSchemaTreeNode parent, @Nullable JsonSchemaObject schema) {
        assert (schema != null || parent != null);
        this.myParent = parent;
        this.mySchema = schema;
        JsonPointerPosition steps = parent != null ? parent.getPosition().skip(1) : null;
        this.myPosition = steps == null ? new JsonPointerPosition() : steps;
    }

    public void anyChild() {
        JsonSchemaTreeNode node = new JsonSchemaTreeNode(this, null);
        node.myAny = true;
        this.myChildren.add(node);
    }

    public void nothingChild() {
        JsonSchemaTreeNode node = new JsonSchemaTreeNode(this, null);
        node.myNothing = true;
        this.myChildren.add(node);
    }

    public void createChildrenFromOperation(@NotNull JsonSchemaVariantsTreeBuilder.Operation operation) {
        if (!SchemaResolveState.normal.equals((Object)operation.myState)) {
            JsonSchemaTreeNode node = new JsonSchemaTreeNode(this, null);
            node.myResolveState = operation.myState;
            this.myChildren.add(node);
            return;
        }
        if (!operation.myAnyOfGroup.isEmpty()) {
            this.myChildren.addAll(this.convertToNodes(operation.myAnyOfGroup));
        }
        if (!operation.myOneOfGroup.isEmpty()) {
            int i = 0;
            while (i < operation.myOneOfGroup.size()) {
                List<JsonSchemaObject> group = operation.myOneOfGroup.get(i);
                List<JsonSchemaTreeNode> children2 = this.convertToNodes(group);
                int number = i++;
                children2.forEach(c -> {
                    c.myExcludingGroupNumber = number;
                });
                this.myChildren.addAll(children2);
            }
        }
    }

    private List<JsonSchemaTreeNode> convertToNodes(List<JsonSchemaObject> children2) {
        ArrayList nodes = ContainerUtil.newArrayListWithCapacity((int)children2.size());
        for (JsonSchemaObject child2 : children2) {
            nodes.add(new JsonSchemaTreeNode(this, child2));
        }
        return nodes;
    }

    @NotNull
    public SchemaResolveState getResolveState() {
        return this.myResolveState;
    }

    public boolean isAny() {
        return this.myAny;
    }

    public boolean isNothing() {
        return this.myNothing;
    }

    public void setChild(@NotNull JsonSchemaObject schema) {
        this.myChildren.add(new JsonSchemaTreeNode(this, schema));
    }

    @Nullable
    public JsonSchemaObject getSchema() {
        return this.mySchema;
    }

    @NotNull
    public JsonPointerPosition getPosition() {
        return this.myPosition;
    }

    @Nullable
    public JsonSchemaTreeNode getParent() {
        return this.myParent;
    }

    @NotNull
    public List<JsonSchemaTreeNode> getChildren() {
        return this.myChildren;
    }

    public int getExcludingGroupNumber() {
        return this.myExcludingGroupNumber;
    }

    public void setPosition(@NotNull JsonPointerPosition steps) {
        this.myPosition.updateFrom(steps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaTreeNode node = (JsonSchemaTreeNode)o;
        if (this.myAny != node.myAny) {
            return false;
        }
        if (this.myNothing != node.myNothing) {
            return false;
        }
        if (this.myResolveState != node.myResolveState) {
            return false;
        }
        if (!Objects.equals(this.mySchema, node.mySchema)) {
            return false;
        }
        return this.myPosition.equals(node.myPosition);
    }

    public int hashCode() {
        int result2 = this.myAny ? 1 : 0;
        result2 = 31 * result2 + (this.myNothing ? 1 : 0);
        result2 = 31 * result2 + this.myResolveState.hashCode();
        result2 = 31 * result2 + (this.mySchema != null ? this.mySchema.hashCode() : 0);
        result2 = 31 * result2 + this.myPosition.hashCode();
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NODE#" + this.hashCode() + "\n");
        sb.append(this.myPosition.toString());
        sb.append("\n");
        if (this.myExcludingGroupNumber >= 0) {
            sb.append("in excluding group\n");
        }
        if (this.myAny) {
            sb.append("any");
        } else if (this.myNothing) {
            sb.append("nothing");
        } else if (!SchemaResolveState.normal.equals((Object)this.myResolveState)) {
            sb.append(this.myResolveState.name());
        } else {
            assert (this.mySchema != null);
            sb.append("schema").append("\n");
            if (this.mySchema.getRef() != null) {
                sb.append("$ref: ").append(this.mySchema.getRef()).append("\n");
            } else if (!this.mySchema.getProperties().isEmpty()) {
                sb.append("properties: ");
                sb.append(String.join((CharSequence)", ", this.mySchema.getProperties().keySet())).append("\n");
            }
            if (!this.myChildren.isEmpty()) {
                sb.append("OR children of NODE#").append(this.hashCode()).append(":\n----------------\n").append(this.myChildren.stream().map(Object::toString).collect(Collectors.joining("\n"))).append("\n=================\n");
            }
        }
        return sb.toString();
    }
}

