/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MatchResult {
    public final List<JsonSchemaObject> mySchemas;
    public final List<Collection<? extends JsonSchemaObject>> myExcludingSchemas;

    private MatchResult(@NotNull List<JsonSchemaObject> schemas, @NotNull List<Collection<? extends JsonSchemaObject>> excludingSchemas) {
        this.mySchemas = Collections.unmodifiableList(schemas);
        this.myExcludingSchemas = Collections.unmodifiableList(excludingSchemas);
    }

    public static MatchResult create(@NotNull JsonSchemaTreeNode root) {
        ArrayList<JsonSchemaObject> schemas = new ArrayList<JsonSchemaObject>();
        MultiMap oneOfGroups = MultiMap.create();
        MatchResult.iterateTree(root, (Processor<? super JsonSchemaTreeNode>)((Processor)node -> {
            if (node.isAny()) {
                return true;
            }
            int groupNumber = node.getExcludingGroupNumber();
            if (groupNumber < 0) {
                schemas.add(node.getSchema());
            } else {
                oneOfGroups.putValue((Object)groupNumber, (Object)node.getSchema());
            }
            return true;
        }));
        List result2 = oneOfGroups.isEmpty() ? ContainerUtil.emptyList() : ContainerUtil.newArrayListWithCapacity((int)oneOfGroups.keySet().size());
        for (Map.Entry entry : oneOfGroups.entrySet()) {
            result2.add(entry.getValue());
        }
        return new MatchResult(schemas, result2);
    }

    public static void iterateTree(@NotNull JsonSchemaTreeNode root, @NotNull Processor<? super JsonSchemaTreeNode> processor2) {
        ArrayDeque<JsonSchemaTreeNode> queue2 = new ArrayDeque<JsonSchemaTreeNode>(root.getChildren());
        while (!queue2.isEmpty()) {
            JsonSchemaTreeNode node = queue2.removeFirst();
            if (node.getChildren().isEmpty()) {
                if (node.isNothing() || !SchemaResolveState.normal.equals((Object)node.getResolveState()) || processor2.process((Object)node)) continue;
                break;
            }
            queue2.addAll(node.getChildren());
        }
    }
}

