/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuggestEnumValuesFix
implements LocalQuickFix,
BatchQuickFix<CommonProblemDescriptor> {
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public SuggestEnumValuesFix(JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return "Replace with allowed value";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        return this.getFamilyName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement initialElement = descriptor.getPsiElement();
        PsiElement element = this.myQuickFixAdapter.adjustValue(initialElement);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(element.getContainingFile().getVirtualFile());
        boolean whitespaceBefore = false;
        if (element.getPrevSibling() instanceof PsiWhiteSpace) {
            whitespaceBefore = true;
        }
        WriteAction.run(() -> element.delete());
        EditorEx editor = EditorUtil.getEditorEx(fileEditor);
        assert (editor != null);
        if (this.myQuickFixAdapter.fixWhitespaceBefore(initialElement, element) && whitespaceBefore) {
            WriteAction.run(() -> {
                int offset = editor.getCaretModel().getOffset();
                editor.getDocument().insertString(offset, " ");
                editor.getCaretModel().moveToOffset(offset + 1);
            });
        }
        CodeCompletionHandlerBase.createHandler(CompletionType.BASIC).invokeCompletion(project, editor);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            HintManager.getInstance().showErrorHint(editor, "Sorry, this fix is not available in batch mode");
        } else {
            Messages.showErrorDialog((Project)project, (String)"Sorry, this fix is not available in batch mode", (String)"Not Applicable in Batch Mode");
        }
    }
}

