/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsonSchemaBasedInspectionBase
extends LocalInspectionTool {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        VirtualFile virtualFile;
        PsiFile file2 = holder.getFile();
        JsonValue root = (JsonValue)ObjectUtils.tryCast((Object)JsonOriginalPsiWalker.INSTANCE.getRoot(file2), JsonValue.class);
        if (root == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        JsonSchemaService service2 = JsonSchemaService.Impl.get(file2.getProject());
        if (!service2.isApplicableToFile(virtualFile = file2.getViewProvider().getVirtualFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return this.doBuildVisitor(root, service2.getSchemaObject(file2), service2, holder, session2);
    }

    protected abstract PsiElementVisitor doBuildVisitor(@NotNull JsonValue var1, @Nullable JsonSchemaObject var2, @NotNull JsonSchemaService var3, @NotNull ProblemsHolder var4, @NotNull LocalInspectionToolSession var5);
}

