/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaComplianceChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.inspections.JsonSchemaBasedInspectionBase;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaComplianceInspection
extends JsonSchemaBasedInspectionBase {
    public boolean myCaseInsensitiveEnum = false;

    @NotNull
    public String getDisplayName() {
        return JsonBundle.message("json.schema.inspection.compliance.name", new Object[0]);
    }

    @Override
    protected PsiElementVisitor doBuildVisitor(final @NotNull JsonValue root, final @Nullable JsonSchemaObject schema, @NotNull JsonSchemaService service2, final @NotNull ProblemsHolder holder, final @NotNull LocalInspectionToolSession session2) {
        if (schema == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        final JsonComplianceCheckerOptions options = new JsonComplianceCheckerOptions(this.myCaseInsensitiveEnum);
        return new JsonElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element == root) {
                    JsonSchemaComplianceInspection.annotate(element, schema, holder, session2, options);
                }
                super.visitElement(element);
            }
        };
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JsonBundle.message("json.schema.inspection.case.insensitive.enum", new Object[0]), "myCaseInsensitiveEnum");
        return optionsPanel;
    }

    private static void annotate(@NotNull PsiElement element, @NotNull JsonSchemaObject rootSchema, @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2, JsonComplianceCheckerOptions options) {
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(element, rootSchema);
        if (walker == null) {
            return;
        }
        new JsonSchemaComplianceChecker(rootSchema, holder, walker, session2, options).annotate(element);
    }
}

