/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.paths.WebReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonPointerReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.inspections.JsonSchemaBasedInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRefReferenceInspection
extends JsonSchemaBasedInspectionBase {
    @NotNull
    public String getDisplayName() {
        return JsonBundle.message("json.schema.ref.refs.inspection.name", new Object[0]);
    }

    @Override
    protected PsiElementVisitor doBuildVisitor(final @NotNull JsonValue root, @Nullable JsonSchemaObject schema, @NotNull JsonSchemaService service2, final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
        final boolean checkRefs = schema != null && service2.isSchemaFile(schema);
        return new JsonElementVisitor(){

            public void visitElement(PsiElement element) {
                JsonProperty schemaProp;
                if (element == root && element instanceof JsonObject && (schemaProp = ((JsonObject)element).findProperty("$schema")) != null) {
                    this.doCheck(schemaProp.getValue());
                }
                super.visitElement(element);
            }

            @Override
            public void visitProperty(@NotNull JsonProperty o) {
                if (!checkRefs) {
                    return;
                }
                if ("$ref".equals(o.getName())) {
                    this.doCheck(o.getValue());
                }
                super.visitProperty(o);
            }

            private void doCheck(JsonValue value) {
                if (!(value instanceof JsonStringLiteral)) {
                    return;
                }
                for (PsiReference reference : value.getReferences()) {
                    PsiElement resolved;
                    if (reference instanceof WebReference || (resolved = reference.resolve()) != null) continue;
                    holder.registerProblem(reference, this.getReferenceErrorDesc(reference), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            private String getReferenceErrorDesc(PsiReference reference) {
                String text = reference.getCanonicalText();
                if (reference instanceof FileReference) {
                    int hash = text.indexOf(35);
                    return JsonBundle.message("json.schema.ref.file.not.found", hash == -1 ? text : text.substring(0, hash));
                }
                if (reference instanceof JsonPointerReferenceProvider.JsonSchemaIdReference) {
                    return JsonBundle.message("json.schema.ref.cannot.resolve.id", text);
                }
                int lastSlash = text.lastIndexOf(47);
                if (lastSlash == -1) {
                    return JsonBundle.message("json.schema.ref.cannot.resolve.path", text);
                }
                String substring = text.substring(text.lastIndexOf(47) + 1);
                try {
                    Integer.parseInt(substring);
                    return JsonBundle.message("json.schema.ref.no.array.element", substring);
                }
                catch (Exception e) {
                    return JsonBundle.message("json.schema.ref.no.property", substring);
                }
            }
        };
    }
}

