/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.settings.mappings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaConfigurable;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaPatternComparator;
import com.jetbrains.jsonSchema.settings.mappings.TreeUpdater;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaMappingsConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable,
Disposable {
    @NonNls
    public static final String SETTINGS_JSON_SCHEMA = "settings.json.schema";
    public static final String JSON_SCHEMA_MAPPINGS = "JSON Schema Mappings";
    private static final Comparator<UserDefinedJsonSchemaConfiguration> COMPARATOR = (o1, o2) -> {
        if (o1.isApplicationDefined() != o2.isApplicationDefined()) {
            return o1.isApplicationDefined() ? 1 : -1;
        }
        return o1.getName().compareToIgnoreCase(o2.getName());
    };
    static final String STUB_SCHEMA_NAME = "New Schema";
    private String myError;
    @NotNull
    private final Project myProject;
    private final TreeUpdater myTreeUpdater = showWarning -> {
        this.TREE_UPDATER.run();
        this.updateWarningText(showWarning);
    };
    private final Function<String, String> myNameCreator = s -> this.createUniqueName((String)s);

    public JsonSchemaMappingsConfigurable(@NotNull Project project) {
        this.myProject = project;
        this.initTree();
    }

    @Nullable
    protected String getEmptySelectionString() {
        return this.myRoot.children().hasMoreElements() ? "Select JSON Schema to view" : "Please add a JSON Schema file and configure its usage";
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)new DumbAwareAction("Add", "Add", IconUtil.getAddIcon()){
            {
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)JsonSchemaMappingsConfigurable.this.myTree);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                JsonSchemaMappingsConfigurable.this.addProjectSchema();
            }
        });
        result2.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return result2;
    }

    public UserDefinedJsonSchemaConfiguration addProjectSchema() {
        UserDefinedJsonSchemaConfiguration configuration2 = new UserDefinedJsonSchemaConfiguration(this.createUniqueName(STUB_SCHEMA_NAME), JsonSchemaVersion.SCHEMA_4, "", false, null);
        this.addCreatedMappings(configuration2);
        return configuration2;
    }

    @NotNull
    private String createUniqueName(@NotNull String s) {
        int max = -1;
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            String displayName;
            Object element = children2.nextElement();
            if (!(element instanceof MasterDetailsComponent.MyNode) || !(displayName = ((MasterDetailsComponent.MyNode)element).getDisplayName()).startsWith(s)) continue;
            String lastPart = displayName.substring(s.length()).trim();
            if (lastPart.length() == 0 && max == -1) {
                max = 1;
                continue;
            }
            int i = JsonSchemaMappingsConfigurable.tryParseInt(lastPart);
            if (i == -1) continue;
            max = i > max ? i : max;
        }
        return max == -1 ? s : s + " " + (max + 1);
    }

    private static int tryParseInt(@NotNull String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private void addCreatedMappings(@NotNull UserDefinedJsonSchemaConfiguration info) {
        JsonSchemaConfigurable configurable = new JsonSchemaConfigurable(this.myProject, "", info, this.myTreeUpdater, this.myNameCreator);
        configurable.setError(this.myError, true);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable);
        this.addNode(node, this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)node, true);
    }

    private void fillTree() {
        this.myRoot.removeAllChildren();
        if (this.myProject.isDefault()) {
            return;
        }
        List<UserDefinedJsonSchemaConfiguration> list2 = this.getStoredList();
        for (UserDefinedJsonSchemaConfiguration info : list2) {
            String pathToSchema = info.getRelativePathToSchema();
            JsonSchemaConfigurable configurable = new JsonSchemaConfigurable(this.myProject, JsonFileResolver.isHttpPath(pathToSchema) || new File(pathToSchema).isAbsolute() ? pathToSchema : new File(this.myProject.getBasePath(), pathToSchema).getPath(), info, this.myTreeUpdater, this.myNameCreator);
            configurable.setError(this.myError, true);
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)configurable));
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
        if (this.myRoot.children().hasMoreElements()) {
            this.myTree.addSelectionRow(0);
        }
    }

    @NotNull
    private List<UserDefinedJsonSchemaConfiguration> getStoredList() {
        ArrayList<UserDefinedJsonSchemaConfiguration> list2 = new ArrayList<UserDefinedJsonSchemaConfiguration>();
        Map<String, UserDefinedJsonSchemaConfiguration> projectState = JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).getStateMap();
        if (projectState != null) {
            list2.addAll(projectState.values());
        }
        Collections.sort(list2, COMPARATOR);
        return list2;
    }

    public void apply() throws ConfigurationException {
        Project[] projects;
        List<UserDefinedJsonSchemaConfiguration> uiList = this.getUiList(true);
        JsonSchemaMappingsConfigurable.validate(uiList);
        HashMap<String, UserDefinedJsonSchemaConfiguration> projectMap = new HashMap<String, UserDefinedJsonSchemaConfiguration>();
        for (UserDefinedJsonSchemaConfiguration info : uiList) {
            projectMap.put(info.getName(), info);
        }
        JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).setState(projectMap);
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            JsonSchemaService service2 = JsonSchemaService.Impl.get(project);
            if (service2 == null) continue;
            service2.reset();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
    }

    private static void validate(@NotNull List<UserDefinedJsonSchemaConfiguration> list2) throws ConfigurationException {
        HashSet<String> set2 = new HashSet<String>();
        for (UserDefinedJsonSchemaConfiguration info : list2) {
            if (set2.contains(info.getName())) {
                throw new ConfigurationException("Duplicate schema name: '" + info.getName() + "'");
            }
            set2.add(info.getName());
        }
    }

    public boolean isModified() {
        List<UserDefinedJsonSchemaConfiguration> uiList;
        List<UserDefinedJsonSchemaConfiguration> storedList = this.getStoredList();
        try {
            uiList = this.getUiList(false);
        }
        catch (ConfigurationException e) {
            return false;
        }
        return !storedList.equals(uiList);
    }

    private void updateWarningText(boolean showWarning) {
        List<UserDefinedJsonSchemaConfiguration> list2;
        MultiMap patternsMap = new MultiMap();
        StringBuilder sb = new StringBuilder();
        try {
            list2 = this.getUiList(false);
        }
        catch (ConfigurationException e) {
            return;
        }
        for (UserDefinedJsonSchemaConfiguration info : list2) {
            info.refreshPatterns();
            JsonSchemaPatternComparator comparator2 = new JsonSchemaPatternComparator(this.myProject);
            List<UserDefinedJsonSchemaConfiguration.Item> patterns = info.getPatterns();
            for (UserDefinedJsonSchemaConfiguration.Item pattern : patterns) {
                for (Map.Entry entry : patternsMap.entrySet()) {
                    for (UserDefinedJsonSchemaConfiguration.Item item : (Collection)entry.getValue()) {
                        ThreeState similar = comparator2.isSimilar(pattern, item);
                        if (ThreeState.NO.equals((Object)similar)) continue;
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append("'").append(pattern.getPresentation()).append("' for schema '").append(info.getName()).append("' and '").append(item.getPresentation()).append("' for schema '").append((String)entry.getKey()).append("'");
                    }
                }
            }
            patternsMap.put((Object)info.getName(), patterns);
        }
        this.myError = sb.length() > 0 ? "Conflicting mappings:\n" + sb.toString() : null;
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            Object o = children2.nextElement();
            if (!(o instanceof MasterDetailsComponent.MyNode) || !(((MasterDetailsComponent.MyNode)o).getConfigurable() instanceof JsonSchemaConfigurable)) continue;
            ((JsonSchemaConfigurable)((MasterDetailsComponent.MyNode)o).getConfigurable()).setError(this.myError, showWarning);
        }
    }

    public void selectInTree(UserDefinedJsonSchemaConfiguration configuration2) {
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)children2.nextElement();
            JsonSchemaConfigurable configurable = (JsonSchemaConfigurable)node.getConfigurable();
            if (!Objects.equals(configurable.getUiSchema(), configuration2)) continue;
            this.selectNodeInTree((DefaultMutableTreeNode)node);
        }
    }

    @NotNull
    private List<UserDefinedJsonSchemaConfiguration> getUiList(boolean applyChildren) throws ConfigurationException {
        ArrayList<UserDefinedJsonSchemaConfiguration> uiList = new ArrayList<UserDefinedJsonSchemaConfiguration>();
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)children2.nextElement();
            if (applyChildren) {
                node.getConfigurable().apply();
                uiList.add(JsonSchemaMappingsConfigurable.getSchemaInfo(node));
                continue;
            }
            uiList.add(((JsonSchemaConfigurable)node.getConfigurable()).getUiSchema());
        }
        Collections.sort(uiList, COMPARATOR);
        return uiList;
    }

    public void reset() {
        this.fillTree();
        this.updateWarningText(true);
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return (o1, o2) -> {
            if (o1.getConfigurable() instanceof JsonSchemaConfigurable && o2.getConfigurable() instanceof JsonSchemaConfigurable) {
                return COMPARATOR.compare(JsonSchemaMappingsConfigurable.getSchemaInfo(o1), JsonSchemaMappingsConfigurable.getSchemaInfo(o2));
            }
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        };
    }

    private static UserDefinedJsonSchemaConfiguration getSchemaInfo(@NotNull MasterDetailsComponent.MyNode node) {
        return ((JsonSchemaConfigurable)node.getConfigurable()).getSchema();
    }

    @Nls
    public String getDisplayName() {
        return JSON_SCHEMA_MAPPINGS;
    }

    public void dispose() {
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            Object o = children2.nextElement();
            if (!(o instanceof MasterDetailsComponent.MyNode)) continue;
            ((MasterDetailsComponent.MyNode)o).getConfigurable().disposeUIResources();
        }
    }

    @NotNull
    public String getId() {
        return SETTINGS_JSON_SCHEMA;
    }

    public String getHelpTopic() {
        return SETTINGS_JSON_SCHEMA;
    }
}

