/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.settings.mappings;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaPatternComparator {
    @NotNull
    private final Project myProject;

    public JsonSchemaPatternComparator(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public ThreeState isSimilar(@NotNull UserDefinedJsonSchemaConfiguration.Item itemLeft, @NotNull UserDefinedJsonSchemaConfiguration.Item itemRight) {
        if (itemLeft.isPattern() != itemRight.isPattern()) {
            return ThreeState.NO;
        }
        if (itemLeft.isPattern()) {
            return JsonSchemaPatternComparator.comparePatterns(itemLeft, itemRight);
        }
        return this.comparePaths(itemLeft, itemRight);
    }

    private ThreeState comparePaths(UserDefinedJsonSchemaConfiguration.Item left, UserDefinedJsonSchemaConfiguration.Item right) {
        String leftPath = left.getPath();
        String rightPath = right.getPath();
        if (leftPath.startsWith("mock:///") || rightPath.startsWith("mock:///")) {
            return leftPath.equals(rightPath) ? ThreeState.YES : ThreeState.NO;
        }
        File leftFile = new File(this.myProject.getBasePath(), leftPath);
        File rightFile = new File(this.myProject.getBasePath(), rightPath);
        if (left.isDirectory() && FileUtil.isAncestor((File)leftFile, (File)rightFile, (boolean)true)) {
            return ThreeState.YES;
        }
        if (right.isDirectory() && FileUtil.isAncestor((File)rightFile, (File)leftFile, (boolean)true)) {
            return ThreeState.YES;
        }
        return FileUtil.filesEqual((File)leftFile, (File)rightFile) && left.isDirectory() == right.isDirectory() ? ThreeState.YES : ThreeState.NO;
    }

    private static ThreeState comparePatterns(@NotNull UserDefinedJsonSchemaConfiguration.Item leftItem, @NotNull UserDefinedJsonSchemaConfiguration.Item rightItem) {
        if (leftItem.getPath().equals(rightItem.getPath())) {
            return ThreeState.YES;
        }
        if (leftItem.getPath().indexOf(File.separatorChar) >= 0 || rightItem.getPath().indexOf(File.separatorChar) >= 0) {
            return ThreeState.NO;
        }
        BeforeAfter<String> left = JsonSchemaPatternComparator.getBeforeAfterAroundWildCards(leftItem.getPath());
        BeforeAfter<String> right = JsonSchemaPatternComparator.getBeforeAfterAroundWildCards(rightItem.getPath());
        if (left == null || right == null) {
            if (left == null && right == null) {
                return leftItem.getPath().equals(rightItem.getPath()) ? ThreeState.YES : ThreeState.NO;
            }
            if (left == null) {
                return JsonSchemaPatternComparator.checkOneSideWithoutWildcard(leftItem, right);
            }
            return JsonSchemaPatternComparator.checkOneSideWithoutWildcard(rightItem, left);
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)left.getBefore())) && !StringUtil.isEmptyOrSpaces((String)((String)right.getBefore()))) {
            if (((String)left.getBefore()).startsWith((String)right.getBefore()) || ((String)right.getBefore()).startsWith((String)left.getBefore())) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)left.getAfter())) && !StringUtil.isEmptyOrSpaces((String)((String)right.getAfter()))) {
            if (((String)left.getAfter()).endsWith((String)right.getAfter()) || ((String)right.getAfter()).endsWith((String)left.getAfter())) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    @NotNull
    private static ThreeState checkOneSideWithoutWildcard(UserDefinedJsonSchemaConfiguration.Item item, BeforeAfter<String> beforeAfter) {
        if (!StringUtil.isEmptyOrSpaces((String)((String)beforeAfter.getBefore())) && item.getPath().startsWith((String)beforeAfter.getBefore())) {
            return ThreeState.YES;
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)beforeAfter.getAfter())) && item.getPath().endsWith((String)beforeAfter.getAfter())) {
            return ThreeState.YES;
        }
        return ThreeState.UNSURE;
    }

    @Nullable
    private static BeforeAfter<String> getBeforeAfterAroundWildCards(@NotNull String pattern) {
        int firstIdx = pattern.indexOf(42);
        int lastIdx = pattern.lastIndexOf(42);
        if (firstIdx < 0 || lastIdx < 0) {
            return null;
        }
        return new BeforeAfter((Object)pattern.substring(0, firstIdx), (Object)pattern.substring(lastIdx + 1));
    }
}

