/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.widget;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaMappingsConfigurable;
import com.jetbrains.jsonSchema.widget.JsonSchemaStatusPopup;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaInfoPopupStep
extends BaseListPopupStep<JsonSchemaInfo>
implements ListPopupStepEx<JsonSchemaInfo> {
    private final Project myProject;
    @Nullable
    private final VirtualFile myVirtualFile;
    @NotNull
    private final JsonSchemaService myService;
    private static final Icon EMPTY_ICON = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)AllIcons.General.Add.getIconWidth()));

    public JsonSchemaInfoPopupStep(@NotNull List<JsonSchemaInfo> allSchemas, @NotNull Project project, @Nullable VirtualFile virtualFile, @NotNull JsonSchemaService service2, @Nullable String title) {
        super(title, allSchemas);
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.myService = service2;
    }

    @NotNull
    public String getTextFor(JsonSchemaInfo value) {
        return value == null ? "" : value.getDescription();
    }

    public Icon getIconFor(JsonSchemaInfo value) {
        if (value == JsonSchemaStatusPopup.ADD_MAPPING) {
            return AllIcons.General.Add;
        }
        if (value == JsonSchemaStatusPopup.EDIT_MAPPINGS) {
            return AllIcons.Actions.Edit;
        }
        if (value == JsonSchemaStatusPopup.LOAD_REMOTE) {
            return AllIcons.Actions.Refresh;
        }
        return EMPTY_ICON;
    }

    @Nullable
    public ListSeparator getSeparatorAbove(JsonSchemaInfo value) {
        List values = this.getValues();
        int index = values.indexOf(value);
        if (index - 1 >= 0) {
            JsonSchemaInfo info = (JsonSchemaInfo)values.get(index - 1);
            if (info == JsonSchemaStatusPopup.EDIT_MAPPINGS || info == JsonSchemaStatusPopup.ADD_MAPPING) {
                return new ListSeparator("Registered schemas");
            }
            if (value.getProvider() == null && info.getProvider() != null) {
                return new ListSeparator("SchemaStore.org schemas");
            }
        }
        return null;
    }

    public PopupStep onChosen(JsonSchemaInfo selectedValue, boolean finalChoice) {
        if (finalChoice) {
            if (selectedValue == JsonSchemaStatusPopup.EDIT_MAPPINGS || selectedValue == JsonSchemaStatusPopup.ADD_MAPPING) {
                return this.doFinalStep(() -> this.runSchemaEditorForCurrentFile());
            }
            if (selectedValue == JsonSchemaStatusPopup.LOAD_REMOTE) {
                return this.doFinalStep(() -> this.myService.triggerUpdateRemote());
            }
            this.setMapping(selectedValue, this.myVirtualFile, this.myProject);
            return this.doFinalStep(() -> this.myService.reset());
        }
        return PopupStep.FINAL_CHOICE;
    }

    protected void runSchemaEditorForCurrentFile() {
        assert (this.myVirtualFile != null) : "override this method to do without a virtual file!";
        JsonSchemaMappingsConfigurable configurable = new JsonSchemaMappingsConfigurable(this.myProject);
        JsonSchemaMappingsProjectConfiguration mappingsConf = JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)configurable, () -> {
            UserDefinedJsonSchemaConfiguration mappingForFile = mappingsConf.findMappingForFile(this.myVirtualFile);
            if (mappingForFile == null) {
                UserDefinedJsonSchemaConfiguration configuration2 = configurable.addProjectSchema();
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)this.myVirtualFile, (VirtualFile)this.myProject.getBaseDir());
                configuration2.patterns.add(new UserDefinedJsonSchemaConfiguration.Item(relativePath == null ? this.myVirtualFile.getUrl() : relativePath, false, false));
                mappingForFile = configuration2;
            }
            configurable.selectInTree(mappingForFile);
        });
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    @Nullable
    public String getTooltipTextFor(JsonSchemaInfo value) {
        return JsonSchemaInfoPopupStep.getDoc(value);
    }

    @Nullable
    private static String getDoc(JsonSchemaInfo schema) {
        if (schema == null) {
            return null;
        }
        if (schema.getName() == null) {
            return schema.getDocumentation();
        }
        if (schema.getDocumentation() == null) {
            return schema.getName();
        }
        return "<b>" + schema.getName() + "</b><br/>" + schema.getDocumentation();
    }

    public void setEmptyText(@NotNull StatusText emptyText) {
    }

    public PopupStep onChosen(JsonSchemaInfo selectedValue, boolean finalChoice, int eventModifiers) {
        return this.onChosen(selectedValue, finalChoice);
    }

    protected void setMapping(@Nullable JsonSchemaInfo selectedValue, @Nullable VirtualFile virtualFile, @NotNull Project project) {
        String path;
        assert (virtualFile != null) : "override this method to do without a virtual file!";
        JsonSchemaMappingsProjectConfiguration configuration2 = JsonSchemaMappingsProjectConfiguration.getInstance(project);
        VirtualFile projectBaseDir = project.getBaseDir();
        UserDefinedJsonSchemaConfiguration mappingForFile = configuration2.findMappingForFile(virtualFile);
        if (mappingForFile != null) {
            for (UserDefinedJsonSchemaConfiguration.Item pattern : mappingForFile.patterns) {
                if (!Objects.equals(VfsUtil.findRelativeFile((VirtualFile)projectBaseDir, (String[])pattern.getPathParts()), virtualFile) && !virtualFile.getUrl().equals(pattern.getPath())) continue;
                mappingForFile.patterns.remove(pattern);
                if (mappingForFile.patterns.size() == 0 && mappingForFile.isApplicationDefined()) {
                    configuration2.removeConfiguration(mappingForFile);
                    break;
                }
                mappingForFile.refreshPatterns();
                break;
            }
        }
        if (selectedValue == null) {
            return;
        }
        String string = path = projectBaseDir == null ? null : VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)projectBaseDir);
        if (path == null) {
            path = virtualFile.getUrl();
        }
        UserDefinedJsonSchemaConfiguration existing = configuration2.findMappingBySchemaInfo(selectedValue);
        UserDefinedJsonSchemaConfiguration.Item item = new UserDefinedJsonSchemaConfiguration.Item(path, false, false);
        if (existing != null) {
            if (!existing.patterns.contains(item)) {
                existing.patterns.add(item);
                existing.refreshPatterns();
            }
        } else {
            configuration2.addConfiguration(new UserDefinedJsonSchemaConfiguration(selectedValue.getDescription(), selectedValue.getSchemaVersion(), selectedValue.getUrl(project), true, Collections.singletonList(item)));
        }
    }
}

