/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.widget;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.widget.JsonSchemaInfoPopupStep;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaStatusPopup {
    static final JsonSchemaInfo ADD_MAPPING = new JsonSchemaInfo(""){

        @Override
        @NotNull
        public String getDescription() {
            return "New Schema Mapping\u2026";
        }
    };
    static final JsonSchemaInfo EDIT_MAPPINGS = new JsonSchemaInfo(""){

        @Override
        @NotNull
        public String getDescription() {
            return "Edit Schema Mappings\u2026";
        }
    };
    public static final JsonSchemaInfo LOAD_REMOTE = new JsonSchemaInfo(""){

        @Override
        @NotNull
        public String getDescription() {
            return "Load SchemaStore Mappings";
        }
    };

    static ListPopup createPopup(@NotNull JsonSchemaService service2, @NotNull Project project, @NotNull VirtualFile virtualFile, boolean showOnlyEdit) {
        JsonSchemaInfoPopupStep step = JsonSchemaStatusPopup.createPopupStep(service2, project, virtualFile, showOnlyEdit);
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
    }

    @NotNull
    static JsonSchemaInfoPopupStep createPopupStep(@NotNull JsonSchemaService service2, @NotNull Project project, @NotNull VirtualFile virtualFile, boolean showOnlyEdit) {
        List allSchemas;
        JsonSchemaMappingsProjectConfiguration configuration2 = JsonSchemaMappingsProjectConfiguration.getInstance(project);
        UserDefinedJsonSchemaConfiguration mapping = configuration2.findMappingForFile(virtualFile);
        if (!showOnlyEdit || mapping == null) {
            List<JsonSchemaInfo> infos = service2.getAllUserVisibleSchemas();
            Comparator<JsonSchemaInfo> comparator2 = Comparator.comparing(JsonSchemaInfo::getDescription, String::compareTo);
            Stream<JsonSchemaInfo> registered = infos.stream().filter(i -> i.getProvider() != null).sorted(comparator2);
            List otherList = ContainerUtil.emptyList();
            if (JsonSchemaCatalogProjectConfiguration.getInstance(project).isRemoteActivityEnabled() && (otherList = infos.stream().filter(i -> i.getProvider() == null).sorted(comparator2).collect(Collectors.toList())).size() == 0) {
                otherList = ContainerUtil.createMaybeSingletonList((Object)LOAD_REMOTE);
            }
            allSchemas = Stream.concat(registered, otherList.stream()).collect(Collectors.toList());
            allSchemas.add(0, mapping == null ? ADD_MAPPING : EDIT_MAPPINGS);
        } else {
            allSchemas = ContainerUtil.createMaybeSingletonList((Object)EDIT_MAPPINGS);
        }
        return new JsonSchemaInfoPopupStep(allSchemas, project, virtualFile, service2, null);
    }
}

