/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.widget;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaEnabler;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.extension.JsonWidgetSuppressor;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import com.jetbrains.jsonSchema.widget.JsonSchemaStatusPopup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonSchemaStatusWidget
extends EditorBasedStatusBarPopup {
    private static final String JSON_SCHEMA_BAR = "JSON: ";
    private static final String JSON_SCHEMA_BAR_OTHER_FILES = "Schema: ";
    private static final String JSON_SCHEMA_TOOLTIP = "JSON Schema: ";
    private static final String JSON_SCHEMA_TOOLTIP_OTHER_FILES = "Validated by JSON Schema: ";
    private final JsonSchemaService myService;
    private static final String ID = "JSONSchemaSelector";
    private static final AtomicBoolean myIsNotified = new AtomicBoolean(false);
    private final Runnable myUpdateCallback = () -> {
        this.update();
        myIsNotified.set(false);
    };

    JsonSchemaStatusWidget(Project project) {
        super(project);
        this.myService = JsonSchemaService.Impl.get(project);
        this.myService.registerRemoteUpdateCallback(this.myUpdateCallback);
        this.myService.registerResetAction(this.myUpdateCallback);
    }

    private boolean hasAccessToSymbols() {
        return !DumbService.getInstance((Project)this.myProject).isDumb();
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        String bar;
        if (file2 == null) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        JsonSchemaEnabler[] enablers = (JsonSchemaEnabler[])JsonSchemaEnabler.EXTENSION_POINT_NAME.getExtensions();
        if (Arrays.stream(enablers).noneMatch(e -> e.isEnabledForFile(file2) && e.shouldShowSwitcherWidget(file2))) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        FileType fileType = file2.getFileType();
        Language language = fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
        boolean isJsonFile = language instanceof JsonLanguage;
        if (!this.hasAccessToSymbols()) {
            return EditorBasedStatusBarPopup.WidgetState.getDumbModeState("JSON schema service", isJsonFile ? JSON_SCHEMA_BAR : JSON_SCHEMA_BAR_OTHER_FILES);
        }
        JsonWidgetSuppressor[] suppressors = (JsonWidgetSuppressor[])JsonWidgetSuppressor.EXTENSION_POINT_NAME.getExtensions();
        if (Arrays.stream(suppressors).anyMatch(s -> s.suppressSwitcherWidget(file2, this.myProject))) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        ArrayList schemaFiles = this.myService.getSchemaFilesForFile(file2);
        if (schemaFiles.size() == 0) {
            return JsonSchemaStatusWidget.getNoSchemaState();
        }
        if (schemaFiles.size() != 1) {
            ArrayList userSchemas = ContainerUtil.newArrayList();
            if (this.hasConflicts(userSchemas, file2)) {
                MyWidgetState state = new MyWidgetState(JsonSchemaStatusWidget.createMessage(schemaFiles, this.myService, "<br/>", "There are several JSON Schemas mapped to this file:<br/>", ""), schemaFiles.size() + " schemas (!)", true);
                state.setWarning(true);
                state.setConflict();
                return state;
            }
            schemaFiles = userSchemas;
            if (schemaFiles.size() == 0) {
                return JsonSchemaStatusWidget.getNoSchemaState();
            }
        }
        VirtualFile schemaFile = schemaFiles.iterator().next();
        schemaFile = ((JsonSchemaServiceImpl)this.myService).replaceHttpFileWithBuiltinIfNeeded(schemaFile);
        String tooltip = isJsonFile ? JSON_SCHEMA_TOOLTIP : JSON_SCHEMA_TOOLTIP_OTHER_FILES;
        String string = bar = isJsonFile ? JSON_SCHEMA_BAR : JSON_SCHEMA_BAR_OTHER_FILES;
        if (schemaFile instanceof HttpVirtualFile) {
            RemoteFileInfo info = ((HttpVirtualFile)schemaFile).getFileInfo();
            if (info == null) {
                return JsonSchemaStatusWidget.getDownloadErrorState(null);
            }
            switch (info.getState()) {
                case DOWNLOADING_NOT_STARTED: {
                    this.addDownloadingUpdateListener(info);
                    return new MyWidgetState(tooltip + JsonSchemaStatusWidget.getSchemaFileDesc(schemaFile), bar + JsonSchemaStatusWidget.getPresentableNameForFile(schemaFile), true);
                }
                case DOWNLOADING_IN_PROGRESS: {
                    this.addDownloadingUpdateListener(info);
                    return new MyWidgetState("Download is scheduled or in progress", "Downloading JSON schema", false);
                }
                case ERROR_OCCURRED: {
                    return JsonSchemaStatusWidget.getDownloadErrorState(info.getErrorMessage());
                }
            }
        }
        if (!this.isValidSchemaFile(schemaFile)) {
            MyWidgetState state = new MyWidgetState("File is not a schema", "JSON schema error", true);
            state.setWarning(true);
            return state;
        }
        JsonSchemaFileProvider provider = this.myService.getSchemaProvider(schemaFile);
        if (provider != null) {
            boolean preferRemoteSchemas = JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).isPreferRemoteSchemas();
            String remoteSource = provider.getRemoteSource();
            String providerName = preferRemoteSchemas && remoteSource != null && !remoteSource.endsWith("!") ? remoteSource : provider.getPresentableName();
            String shortName = StringUtil.trimEnd((String)StringUtil.trimEnd((String)providerName, (String)".json"), (String)"-schema");
            String name = preferRemoteSchemas && remoteSource != null && !remoteSource.endsWith("!") ? bar + new JsonSchemaInfo(remoteSource).getDescription() : (shortName.startsWith("JSON schema") ? shortName : bar + shortName);
            String kind = !preferRemoteSchemas && (provider.getSchemaType() == SchemaType.embeddedSchema || provider.getSchemaType() == SchemaType.schema) ? " (bundled)" : "";
            return new MyWidgetState(tooltip + providerName + kind, name, true);
        }
        return new MyWidgetState(tooltip + JsonSchemaStatusWidget.getSchemaFileDesc(schemaFile), bar + JsonSchemaStatusWidget.getPresentableNameForFile(schemaFile), true);
    }

    private void addDownloadingUpdateListener(@NotNull RemoteFileInfo info) {
        info.addDownloadingListener(new FileDownloadingAdapter(){

            @Override
            public void fileDownloaded(@NotNull VirtualFile localFile) {
                JsonSchemaStatusWidget.this.update();
            }

            @Override
            public void errorOccurred(@NotNull String errorMessage) {
                JsonSchemaStatusWidget.this.update();
            }

            @Override
            public void downloadingCancelled() {
                JsonSchemaStatusWidget.this.update();
            }
        });
    }

    private boolean isValidSchemaFile(@Nullable VirtualFile schemaFile) {
        return schemaFile != null && this.myService.isSchemaFile(schemaFile) && this.myService.isApplicableToFile(schemaFile);
    }

    @Nullable
    private static String extractNpmPackageName(@Nullable String path) {
        int trimIndex;
        if (path == null) {
            return null;
        }
        int idx = path.indexOf("node_modules");
        if (idx != -1 && (trimIndex = idx + "node_modules".length() + 1) < path.length()) {
            idx = StringUtil.indexOfAny((String)(path = path.substring(trimIndex)), (String)"\\/");
            if (idx != -1 && path.startsWith("@")) {
                idx = StringUtil.indexOfAny((String)path, (String)"\\/", (int)(idx + 1), (int)path.length());
            }
            if (idx != -1) {
                return path.substring(0, idx);
            }
        }
        return null;
    }

    @NotNull
    private static String getPresentableNameForFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile instanceof HttpVirtualFile) {
            return new JsonSchemaInfo(schemaFile.getUrl()).getDescription();
        }
        String nameWithoutExtension = schemaFile.getNameWithoutExtension();
        if (!JsonSchemaInfo.isVeryDumbName(nameWithoutExtension)) {
            return nameWithoutExtension;
        }
        String path = schemaFile.getPath();
        String npmPackageName = JsonSchemaStatusWidget.extractNpmPackageName(path);
        return npmPackageName != null ? npmPackageName : schemaFile.getName();
    }

    @NotNull
    private static EditorBasedStatusBarPopup.WidgetState getDownloadErrorState(@Nullable String message) {
        MyWidgetState state = new MyWidgetState("Error downloading schema" + (message == null ? "" : ": <br/>" + message), "JSON schema error", true);
        state.setWarning(true);
        return state;
    }

    @NotNull
    private static EditorBasedStatusBarPopup.WidgetState getNoSchemaState() {
        return new MyWidgetState("No JSON Schema defined", "No JSON schema", true);
    }

    @NotNull
    private static String getSchemaFileDesc(@NotNull VirtualFile schemaFile) {
        if (schemaFile instanceof HttpVirtualFile) {
            return schemaFile.getPresentableUrl();
        }
        String npmPackageName = JsonSchemaStatusWidget.extractNpmPackageName(schemaFile.getPath());
        return schemaFile.getName() + (npmPackageName == null ? "" : " (Package: " + npmPackageName + ")");
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context) {
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (virtualFile == null) {
            return null;
        }
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        EditorBasedStatusBarPopup.WidgetState state = this.getWidgetState(virtualFile);
        if (!(state instanceof MyWidgetState)) {
            return null;
        }
        return this.doCreatePopup(virtualFile, project, ((MyWidgetState)state).isWarning());
    }

    @NotNull
    private ListPopup doCreatePopup(@NotNull VirtualFile virtualFile, @NotNull Project project, boolean showOnlyEdit) {
        return JsonSchemaStatusPopup.createPopup(this.myService, project, virtualFile, showOnlyEdit);
    }

    @Override
    protected void registerCustomListeners() {
        class Listener
        implements DumbService.DumbModeListener {
            volatile boolean isDumbMode;

            Listener() {
            }

            public void enteredDumbMode() {
                this.isDumbMode = true;
                JsonSchemaStatusWidget.this.update();
            }

            public void exitDumbMode() {
                this.isDumbMode = false;
                JsonSchemaStatusWidget.this.update();
            }
        }
        Listener listener2 = new Listener();
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)listener2);
    }

    @Override
    protected void handleFileChange(VirtualFile file2) {
        myIsNotified.set(false);
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(Project project) {
        return new JsonSchemaStatusWidget(project);
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @Override
    public void dispose() {
        this.myService.unregisterRemoteUpdateCallback(this.myUpdateCallback);
        this.myService.unregisterResetAction(this.myUpdateCallback);
        super.dispose();
    }

    private static String createMessage(@NotNull Collection<? extends VirtualFile> schemaFiles, @NotNull JsonSchemaService jsonSchemaService, @NotNull String separator, @NotNull String prefix, @NotNull String suffix) {
        List pairList = schemaFiles.stream().map(file2 -> jsonSchemaService.getSchemaProvider((VirtualFile)file2)).filter(Objects::nonNull).map(provider -> Pair.create((Object)SchemaType.userSchema.equals((Object)provider.getSchemaType()), (Object)provider.getName())).collect(Collectors.toList());
        long numOfSystemSchemas = pairList.stream().filter(pair -> (Boolean)pair.getFirst() == false).count();
        if (pairList.size() == 2 && numOfSystemSchemas == 1L) {
            return null;
        }
        boolean withTypes = numOfSystemSchemas > 0L;
        return pairList.stream().map(pair -> JsonSchemaStatusWidget.formatName(withTypes, (Pair<Boolean, String>)pair)).collect(Collectors.joining(separator, prefix, suffix));
    }

    private static String formatName(boolean withTypes, Pair<Boolean, String> pair) {
        return "&nbsp;&nbsp;- " + (withTypes ? String.format("%s schema '%s'", Boolean.TRUE.equals(pair.getFirst()) ? "user" : "system", pair.getSecond()) : (String)pair.getSecond());
    }

    private boolean hasConflicts(@NotNull Collection<VirtualFile> files2, @NotNull VirtualFile file2) {
        List<JsonSchemaFileProvider> providers = ((JsonSchemaServiceImpl)this.myService).getProvidersForFile(file2);
        for (JsonSchemaFileProvider provider : providers) {
            VirtualFile schemaFile;
            if (provider.getSchemaType() != SchemaType.userSchema || (schemaFile = provider.getSchemaFile()) == null) continue;
            files2.add(schemaFile);
        }
        return files2.size() > 1;
    }

    @Override
    protected void afterVisibleUpdate(@NotNull EditorBasedStatusBarPopup.WidgetState state) {
        if (!(state instanceof MyWidgetState) || !((MyWidgetState)state).conflict) {
            myIsNotified.set(false);
            return;
        }
        if (myIsNotified.get()) {
            return;
        }
        myIsNotified.set(true);
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        alarm.addRequest(() -> {
            JComponent label2 = HintUtil.createErrorLabel("<b>JSON Schema conflicting mappings</b><br/><br/>" + ((MyWidgetState)state).getTooltip());
            BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder(label2);
            JComponent statusBarComponent = this.getComponent();
            Balloon balloon = builder2.setCalloutShift(statusBarComponent.getHeight() / 2).setDisposable((Disposable)this).setFillColor(HintUtil.getErrorColor()).setHideOnClickOutside(true).createBalloon();
            balloon.showInCenterOf(statusBarComponent);
        }, 500, ModalityState.NON_MODAL);
    }

    private static class MyWidgetState
    extends EditorBasedStatusBarPopup.WidgetState {
        boolean warning = false;
        boolean conflict = false;

        MyWidgetState(String toolTip, String text, boolean actionEnabled) {
            super(toolTip, text, actionEnabled);
        }

        public boolean isWarning() {
            return this.warning;
        }

        public void setWarning(boolean warning) {
            this.warning = warning;
            this.setIcon(warning ? AllIcons.General.Warning : null);
        }

        private void setConflict() {
            this.conflict = true;
        }

        private String getTooltip() {
            return this.toolTip;
        }
    }
}

