/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.html;

import com.intellij.html.RelaxedHtmlNSDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.List;
import org.intellij.html.RelaxedHtmlFromRngElementDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.RngNsDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelaxedHtmlFromRngNSDescriptor
extends RngNsDescriptor
implements RelaxedHtmlNSDescriptor {
    private static final Logger LOG = Logger.getInstance((String)"#org.intellij.html.RelaxedHtmlFromRngNSDescriptor");

    @Override
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        String namespace;
        XmlElementDescriptor elementDescriptor = super.getElementDescriptor(tag);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Descriptor from rng for tag " + tag.getName() + " is " + (elementDescriptor != null ? elementDescriptor.getClass().getCanonicalName() : "NULL"));
        }
        if (elementDescriptor == null && !(namespace = tag.getNamespace()).equals("http://www.w3.org/1999/xhtml")) {
            return new AnyXmlElementDescriptor(null, (XmlNSDescriptor)("http://www.w3.org/1999/html".equals(namespace) ? this : tag.getNSDescriptor(tag.getNamespace(), true)));
        }
        return elementDescriptor;
    }

    @Override
    protected XmlElementDescriptor initDescriptor(@NotNull XmlElementDescriptor descriptor) {
        return new RelaxedHtmlFromRngElementDescriptor(descriptor);
    }

    @Override
    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument doc) {
        Object[] descriptors = super.getRootElementsDescriptors(doc);
        List rootElements = ContainerUtil.filter((Object[])descriptors, descriptor -> this.isRootTag((RelaxedHtmlFromRngElementDescriptor)descriptor));
        ContainerUtil.addAll((Collection)rootElements, (Object[])HtmlUtil.getCustomTagDescriptors((PsiElement)doc));
        return rootElements.toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    public XmlElementDescriptor[] getAllElementsDescriptors(@Nullable XmlDocument document) {
        return super.getRootElementsDescriptors(document);
    }

    protected boolean isRootTag(RelaxedHtmlFromRngElementDescriptor descriptor) {
        return descriptor.isHtml() || "svg".equals(descriptor.getName()) || "math".equals(descriptor.getName());
    }

    @Override
    public XmlElementDescriptor getElementDescriptor(String localName, String namespace) {
        XmlElementDescriptor descriptor = super.getElementDescriptor(localName, namespace);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = super.getElementDescriptor(localName, "http://www.w3.org/1998/Math/MathML");
        if (descriptor != null) {
            return descriptor;
        }
        return super.getElementDescriptor(localName, "http://www.w3.org/2000/svg");
    }
}

