/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.LazyInitializer;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.intellij.images.ImagesBundle;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.ZoomOptions;
import org.intellij.images.ui.ImageComponent;
import org.intellij.images.ui.ImageComponentDecorator;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImageEditorUI
extends JPanel
implements DataProvider,
CopyProvider,
ImageComponentDecorator,
Disposable {
    @NonNls
    private static final String IMAGE_PANEL = "image";
    @NonNls
    private static final String ERROR_PANEL = "error";
    @NonNls
    private static final String ZOOM_FACTOR_PROP = "ImageEditor.zoomFactor";
    @Nullable
    private final ImageEditor editor;
    private final DeleteProvider deleteProvider;
    private final CopyPasteSupport copyPasteSupport;
    private final ImageZoomModel zoomModel = new ImageZoomModelImpl();
    private final ImageWheelAdapter wheelAdapter = new ImageWheelAdapter();
    private final ChangeListener changeListener = new DocumentChangeListener();
    private final ImageComponent imageComponent = new ImageComponent();
    private final JPanel contentPanel;
    private final JLabel infoLabel;
    private final PropertyChangeListener optionsChangeListener = new OptionsChangeListener();
    private final JScrollPane myScrollPane;

    ImageEditorUI(@Nullable ImageEditor editor) {
        this.editor = editor;
        this.imageComponent.addPropertyChangeListener(ZOOM_FACTOR_PROP, e -> this.imageComponent.setZoomFactor(this.getZoomModel().getZoomFactor()));
        Options options = OptionsManager.getInstance().getOptions();
        EditorOptions editorOptions = options.getEditorOptions();
        options.addPropertyChangeListener(this.optionsChangeListener);
        this.copyPasteSupport = editor != null ? new CopyPasteDelegator(editor.getProject(), this) : null;
        this.deleteProvider = new DeleteHandler.DefaultDeleteProvider();
        ImageDocument document = this.imageComponent.getDocument();
        document.addChangeListener(this.changeListener);
        TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        this.imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
        this.imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
        this.imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
        this.imageComponent.setGridLineZoomFactor(gridOptions.getLineZoomFactor());
        this.imageComponent.setGridLineSpan(gridOptions.getLineSpan());
        this.imageComponent.setGridLineColor(gridOptions.getLineColor());
        ImageContainerPane view = new ImageContainerPane(this.imageComponent);
        view.addMouseListener((MouseListener)((Object)new EditorMouseAdapter()));
        view.addMouseListener(new FocusRequester());
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)view), (boolean)true);
        this.myScrollPane.setVerticalScrollBarPolicy(20);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.addMouseWheelListener(this.wheelAdapter);
        this.setLayout(new BorderLayout());
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup actionGroup = (ActionGroup)actionManager.getAction("Images.EditorToolbar");
        ActionToolbar actionToolbar = actionManager.createActionToolbar("Images.Editor", actionGroup, true);
        actionToolbar.updateActionsImmediately();
        actionToolbar.setTargetComponent((JComponent)this);
        JComponent toolbarPanel = actionToolbar.getComponent();
        toolbarPanel.addMouseListener(new FocusRequester());
        JLabel errorLabel = new JLabel(ImagesBundle.message("error.broken.image.file.format", new Object[0]), Messages.getErrorIcon(), 0);
        JPanel errorPanel = new JPanel(new BorderLayout());
        errorPanel.add((Component)errorLabel, "Center");
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.add((Component)this.myScrollPane, IMAGE_PANEL);
        this.contentPanel.add((Component)errorPanel, ERROR_PANEL);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)toolbarPanel, "West");
        this.infoLabel = new JLabel((String)null, 4);
        this.infoLabel.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        topPanel.add((Component)this.infoLabel, "East");
        this.add((Component)topPanel, "North");
        this.add((Component)this.contentPanel, "Center");
        this.myScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ImageEditorUI.this.updateZoomFactor();
            }
        });
        this.updateInfo();
    }

    private void updateInfo() {
        ImageDocument document = this.imageComponent.getDocument();
        BufferedImage image = document.getValue();
        if (image != null) {
            ColorModel colorModel = image.getColorModel();
            String format = document.getFormat();
            format = format == null ? (this.editor != null ? ImagesBundle.message("unknown.format", new Object[0]) : "") : format.toUpperCase(Locale.ENGLISH);
            VirtualFile file2 = this.editor != null ? this.editor.getFile() : null;
            this.infoLabel.setText(ImagesBundle.message("image.info", image.getWidth(), image.getHeight(), format, colorModel.getPixelSize(), file2 != null ? StringUtil.formatFileSize((long)file2.getLength()) : ""));
        } else {
            this.infoLabel.setText(null);
        }
    }

    JComponent getContentComponent() {
        return this.contentPanel;
    }

    ImageComponent getImageComponent() {
        return this.imageComponent;
    }

    public void dispose() {
        Options options = OptionsManager.getInstance().getOptions();
        options.removePropertyChangeListener(this.optionsChangeListener);
        this.imageComponent.removeMouseWheelListener(this.wheelAdapter);
        this.imageComponent.getDocument().removeChangeListener(this.changeListener);
        this.removeAll();
    }

    @Override
    public void setTransparencyChessboardVisible(boolean visible) {
        this.imageComponent.setTransparencyChessboardVisible(visible);
        this.repaint();
    }

    @Override
    public boolean isTransparencyChessboardVisible() {
        return this.imageComponent.isTransparencyChessboardVisible();
    }

    @Override
    public boolean isEnabledForActionPlace(String place) {
        return !"Images.Thumbnails".equals(place);
    }

    @Override
    public void setGridVisible(boolean visible) {
        this.imageComponent.setGridVisible(visible);
        this.repaint();
    }

    @Override
    public boolean isGridVisible() {
        return this.imageComponent.isGridVisible();
    }

    @Override
    public ImageZoomModel getZoomModel() {
        return this.zoomModel;
    }

    public void setImageProvider(ImageDocument.ScaledImageProvider imageProvider, String format) {
        Options options;
        ZoomOptions zoomOptions;
        ImageDocument document = this.imageComponent.getDocument();
        BufferedImage previousImage = document.getValue();
        document.setValue(imageProvider);
        if (imageProvider == null) {
            return;
        }
        document.setFormat(format);
        if (!(previousImage != null && this.zoomModel.isZoomLevelChanged() || (zoomOptions = (options = OptionsManager.getInstance().getOptions()).getEditorOptions().getZoomOptions()).isSmartZooming() && this.updateZoomFactor())) {
            this.zoomModel.setZoomFactor(1.0);
        }
    }

    private boolean updateZoomFactor() {
        Double smartZoomFactor;
        Options options = OptionsManager.getInstance().getOptions();
        ZoomOptions zoomOptions = options.getEditorOptions().getZoomOptions();
        if (zoomOptions.isSmartZooming() && !this.zoomModel.isZoomLevelChanged() && (smartZoomFactor = this.getSmartZoomFactor(zoomOptions)) != null) {
            this.zoomModel.setZoomFactor(smartZoomFactor);
            return true;
        }
        return false;
    }

    @Nullable
    private Double getSmartZoomFactor(@NotNull ZoomOptions zoomOptions) {
        Rectangle bounds2 = this.imageComponent.getDocument().getBounds();
        if (bounds2 == null) {
            return null;
        }
        if (bounds2.getWidth() == 0.0 || bounds2.getHeight() == 0.0) {
            return null;
        }
        int width = bounds2.width;
        int height = bounds2.height;
        Dimension preferredMinimumSize = zoomOptions.getPrefferedSize();
        if (width < preferredMinimumSize.width && height < preferredMinimumSize.height) {
            double factor = (preferredMinimumSize.getWidth() / (double)width + preferredMinimumSize.getHeight() / (double)height) / 2.0;
            return Math.ceil(factor);
        }
        Dimension canvasSize = this.myScrollPane.getViewport().getExtentSize();
        canvasSize.height -= 4;
        canvasSize.width -= 4;
        if (canvasSize.width <= 0 || canvasSize.height <= 0) {
            return null;
        }
        if (canvasSize.width < width || canvasSize.height < height) {
            return Math.min((double)canvasSize.height / (double)height, (double)canvasSize.width / (double)width);
        }
        return 1.0;
    }

    private void updateImageComponentSize() {
        Rectangle bounds2 = this.imageComponent.getDocument().getBounds();
        if (bounds2 != null) {
            double zoom = this.getZoomModel().getZoomFactor();
            this.imageComponent.setCanvasSize((int)Math.ceil((double)bounds2.width * zoom), (int)Math.ceil((double)bounds2.height * zoom));
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.editor != null ? this.editor.getProject() : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.editor != null ? this.editor.getFile() : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            VirtualFile[] virtualFileArray;
            if (this.editor != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = this.editor.getFile();
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            return virtualFileArray;
        }
        if (CommonDataKeys.PSI_FILE.is(dataId)) {
            return this.findPsiFile();
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return this.findPsiFile();
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            PsiElement[] psiElementArray;
            PsiFile psi = this.findPsiFile();
            if (psi != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = psi;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            return psiElementArray;
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) && this.copyPasteSupport != null) {
            return this;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId) && this.copyPasteSupport != null) {
            return this.copyPasteSupport.getCutProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.deleteProvider;
        }
        if (ImageComponentDecorator.DATA_KEY.is(dataId)) {
            return this.editor != null ? this.editor : this;
        }
        return null;
    }

    @Nullable
    private PsiFile findPsiFile() {
        VirtualFile file2 = this.editor != null ? this.editor.getFile() : null;
        return file2 != null && file2.isValid() ? PsiManager.getInstance((Project)this.editor.getProject()).findFile(file2) : null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        ImageDocument document = this.imageComponent.getDocument();
        BufferedImage image = document.getValue();
        CopyPasteManager.getInstance().setContents((Transferable)new ImageTransferable(image));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return true;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }

    private class OptionsChangeListener
    implements PropertyChangeListener {
        private OptionsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Options options = (Options)evt.getSource();
            EditorOptions editorOptions = options.getEditorOptions();
            TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
            GridOptions gridOptions = editorOptions.getGridOptions();
            ImageEditorUI.this.imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
            ImageEditorUI.this.imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
            ImageEditorUI.this.imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
            ImageEditorUI.this.imageComponent.setGridLineZoomFactor(gridOptions.getLineZoomFactor());
            ImageEditorUI.this.imageComponent.setGridLineSpan(gridOptions.getLineSpan());
            ImageEditorUI.this.imageComponent.setGridLineColor(gridOptions.getLineColor());
        }
    }

    private static class ImageTransferable
    implements Transferable {
        private final BufferedImage myImage;

        ImageTransferable(@NotNull BufferedImage image) {
            this.myImage = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DataFlavor.imageFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.myImage;
        }
    }

    private static final class EditorMouseAdapter
    extends PopupHandler {
        private EditorMouseAdapter() {
        }

        public void invokePopup(Component comp, int x, int y) {
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup actionGroup = (ActionGroup)actionManager.getAction("Images.EditorPopupMenu");
            ActionPopupMenu menu2 = actionManager.createActionPopupMenu("Images.Editor", actionGroup);
            JPopupMenu popupMenu = menu2.getComponent();
            popupMenu.pack();
            popupMenu.show(comp, x, y);
        }
    }

    private class FocusRequester
    extends MouseAdapter {
        private FocusRequester() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)ImageEditorUI.this, true));
        }
    }

    private class DocumentChangeListener
    implements ChangeListener {
        private DocumentChangeListener() {
        }

        @Override
        public void stateChanged(@NotNull ChangeEvent e) {
            ImageEditorUI.this.updateImageComponentSize();
            ImageDocument document = ImageEditorUI.this.imageComponent.getDocument();
            BufferedImage value = document.getValue();
            CardLayout layout = (CardLayout)ImageEditorUI.this.contentPanel.getLayout();
            layout.show(ImageEditorUI.this.contentPanel, value != null ? ImageEditorUI.IMAGE_PANEL : ImageEditorUI.ERROR_PANEL);
            ImageEditorUI.this.updateInfo();
            ImageEditorUI.this.revalidate();
            ImageEditorUI.this.repaint();
        }
    }

    private class ImageZoomModelImpl
    implements ImageZoomModel {
        private boolean myZoomLevelChanged;
        private final LazyInitializer.NotNullValue<Double> IMAGE_MAX_ZOOM_FACTOR = new LazyInitializer.NotNullValue<Double>(){

            @NotNull
            public Double initialize() {
                if (ImageEditorUI.this.editor == null) {
                    return Double.MAX_VALUE;
                }
                VirtualFile file2 = ImageEditorUI.this.editor.getFile();
                if (IfsUtil.isSVG(file2)) {
                    try {
                        URL url = new File(file2.getPath()).toURI().toURL();
                        return Math.max(1.0, SVGLoader.getMaxZoomFactor((URL)url, (InputStream)new ByteArrayInputStream(file2.contentsToByteArray()), (JBUI.ScaleContext)JBUI.ScaleContext.create((Component)ImageEditorUI.this.editor.getComponent())));
                    }
                    catch (Throwable t) {
                        Logger.getInstance((String)"#org.intellij.images.editor.impl.ImageEditorUI").warn(t);
                    }
                }
                return Double.MAX_VALUE;
            }
        };
        private double zoomFactor = 0.0;

        private ImageZoomModelImpl() {
        }

        @Override
        public double getZoomFactor() {
            return this.zoomFactor;
        }

        @Override
        public void setZoomFactor(double zoomFactor) {
            double oldZoomFactor = this.getZoomFactor();
            if (Double.compare(oldZoomFactor, zoomFactor) == 0) {
                return;
            }
            this.zoomFactor = zoomFactor;
            ImageEditorUI.this.updateImageComponentSize();
            ImageEditorUI.this.revalidate();
            ImageEditorUI.this.repaint();
            this.myZoomLevelChanged = false;
            ImageEditorUI.this.imageComponent.firePropertyChange(ImageEditorUI.ZOOM_FACTOR_PROP, oldZoomFactor, zoomFactor);
        }

        private double getMaximumZoomFactor() {
            double factor = (Double)this.IMAGE_MAX_ZOOM_FACTOR.get();
            return Math.min(factor, MACRO_ZOOM_LIMIT);
        }

        private double getMinimumZoomFactor() {
            Rectangle bounds2 = ImageEditorUI.this.imageComponent.getDocument().getBounds();
            double factor = bounds2 != null ? 1.0 / bounds2.getWidth() : 0.0;
            return Math.max(factor, MICRO_ZOOM_LIMIT);
        }

        @Override
        public void fitZoomToWindow() {
            Options options = OptionsManager.getInstance().getOptions();
            ZoomOptions zoomOptions = options.getEditorOptions().getZoomOptions();
            Double smartZoomFactor = ImageEditorUI.this.getSmartZoomFactor(zoomOptions);
            if (smartZoomFactor != null) {
                ImageEditorUI.this.zoomModel.setZoomFactor(smartZoomFactor);
            } else {
                ImageEditorUI.this.zoomModel.setZoomFactor(1.0);
            }
            this.myZoomLevelChanged = false;
        }

        @Override
        public void zoomOut() {
            this.setZoomFactor(this.getNextZoomOut());
            this.myZoomLevelChanged = true;
        }

        @Override
        public void zoomIn() {
            this.setZoomFactor(this.getNextZoomIn());
            this.myZoomLevelChanged = true;
        }

        private double getNextZoomOut() {
            double factor = this.getZoomFactor();
            if (factor > 1.0) {
                factor /= 2.0;
                factor = Math.max(factor, 1.0);
            } else {
                factor /= 1.5;
            }
            return Math.max(factor, this.getMinimumZoomFactor());
        }

        private double getNextZoomIn() {
            double factor = this.getZoomFactor();
            if (factor >= 1.0) {
                factor *= 2.0;
            } else {
                factor *= 1.5;
                factor = Math.min(factor, 1.0);
            }
            return Math.min(factor, this.getMaximumZoomFactor());
        }

        @Override
        public boolean canZoomOut() {
            return this.getZoomFactor() - 1.0E-14 > this.getMinimumZoomFactor();
        }

        @Override
        public boolean canZoomIn() {
            return this.getZoomFactor() < this.getMaximumZoomFactor();
        }

        @Override
        public void setZoomLevelChanged(boolean value) {
            this.myZoomLevelChanged = value;
        }

        @Override
        public boolean isZoomLevelChanged() {
            return this.myZoomLevelChanged;
        }
    }

    private final class ImageWheelAdapter
    implements MouseWheelListener {
        private ImageWheelAdapter() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Options options = OptionsManager.getInstance().getOptions();
            EditorOptions editorOptions = options.getEditorOptions();
            ZoomOptions zoomOptions = editorOptions.getZoomOptions();
            if (zoomOptions.isWheelZooming() && e.isControlDown()) {
                int rotation = e.getWheelRotation();
                double oldZoomFactor = ImageEditorUI.this.zoomModel.getZoomFactor();
                Point oldPosition = ImageEditorUI.this.myScrollPane.getViewport().getViewPosition();
                if (rotation > 0) {
                    ImageEditorUI.this.zoomModel.zoomOut();
                } else if (rotation < 0) {
                    ImageEditorUI.this.zoomModel.zoomIn();
                }
                Component view = ImageEditorUI.this.myScrollPane.getViewport().getView();
                ImageEditorUI.this.myScrollPane.setViewport(null);
                ImageEditorUI.this.myScrollPane.setViewportView(view);
                if (oldZoomFactor > 0.0 && rotation != 0) {
                    Point mousePoint = e.getPoint();
                    double zoomChange = ImageEditorUI.this.zoomModel.getZoomFactor() / oldZoomFactor;
                    Point newPosition = new Point((int)Math.max(0.0, (oldPosition.getX() + mousePoint.getX()) * zoomChange - mousePoint.getX()), (int)Math.max(0.0, (oldPosition.getY() + mousePoint.getY()) * zoomChange - mousePoint.getY()));
                    ImageEditorUI.this.myScrollPane.getViewport().setViewPosition(newPosition);
                }
                e.consume();
            }
        }
    }

    private final class ImageContainerPane
    extends JBLayeredPane {
        private final ImageComponent imageComponent;

        ImageContainerPane(final ImageComponent imageComponent) {
            this.imageComponent = imageComponent;
            this.add(imageComponent);
            this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, new Magnificator(){

                public Point magnify(double scale, Point at) {
                    Point locationBefore = imageComponent.getLocation();
                    ImageZoomModel model = ImageEditorUI.this.editor != null ? ImageEditorUI.this.editor.getZoomModel() : ImageEditorUI.this.getZoomModel();
                    double factor = model.getZoomFactor();
                    model.setZoomFactor(scale * factor);
                    return new Point((int)((double)(at.x - Math.max(scale > 1.0 ? locationBefore.x : 0, 0)) * scale), (int)((double)(at.y - Math.max(scale > 1.0 ? locationBefore.y : 0, 0)) * scale));
                }
            });
        }

        private void centerComponents() {
            Rectangle bounds2 = this.getBounds();
            Point point = this.imageComponent.getLocation();
            point.x = (bounds2.width - this.imageComponent.getWidth()) / 2;
            point.y = (bounds2.height - this.imageComponent.getHeight()) / 2;
            this.imageComponent.setLocation(point);
        }

        public void invalidate() {
            this.centerComponents();
            super.invalidate();
        }

        public Dimension getPreferredSize() {
            return this.imageComponent.getSize();
        }

        protected void paintComponent(@NotNull Graphics g) {
            super.paintComponent(g);
            if (UIUtil.isUnderDarcula()) {
                g.setColor(UIUtil.getControlColor().brighter());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }
}

