/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.fileTypes.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import icons.ImagesIcons;
import java.util.Collection;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.fileTypes.impl.SvgFileType;
import org.jetbrains.annotations.NotNull;

final class ImageFileTypeManagerImpl
extends ImageFileTypeManager {
    private static final String IMAGE_FILE_TYPE_NAME = "Image";
    private static final String IMAGE_FILE_TYPE_DESCRIPTION = ImagesBundle.message("images.filetype.description", new Object[0]);
    private static final UserFileType IMAGE_FILE_TYPE = new ImageFileType();

    ImageFileTypeManagerImpl() {
    }

    @Override
    public boolean isImage(@NotNull VirtualFile file2) {
        return file2.getFileType() == IMAGE_FILE_TYPE || file2.getFileType() instanceof SvgFileType;
    }

    @Override
    @NotNull
    public FileType getImageFileType() {
        return IMAGE_FILE_TYPE;
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        THashSet processed2 = new THashSet();
        for (String format : ImageIO.getReaderFormatNames()) {
            processed2.add(format.toLowerCase(Locale.ENGLISH));
        }
        processed2.add("ico".toLowerCase(Locale.ENGLISH));
        consumer.consume((FileType)IMAGE_FILE_TYPE, StringUtil.join((Collection)processed2, (String)";"));
        consumer.consume((FileType)SvgFileType.INSTANCE, "svg");
    }

    public static final class ImageFileType
    extends UserBinaryFileType {
        private ImageFileType() {
            this.setName(ImageFileTypeManagerImpl.IMAGE_FILE_TYPE_NAME);
            this.setDescription(IMAGE_FILE_TYPE_DESCRIPTION);
        }

        public Icon getIcon() {
            return ImagesIcons.ImagesFileType;
        }
    }
}

