/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.ui.ImageComponentDecorator;
import org.jetbrains.annotations.NotNull;

public final class ToggleFileSizeAction
extends ToggleAction {
    public boolean isSelected(@NotNull AnActionEvent e) {
        ImageComponentDecorator decorator = (ImageComponentDecorator)ImageComponentDecorator.DATA_KEY.getData(e.getDataContext());
        return decorator != null && decorator.isEnabledForActionPlace(e.getPlace()) && decorator.isFileSizeVisible();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        ImageComponentDecorator decorator = (ImageComponentDecorator)ImageComponentDecorator.DATA_KEY.getData(e.getDataContext());
        if (decorator != null && decorator.isEnabledForActionPlace(e.getPlace())) {
            decorator.setFileSizeVisible(state);
            OptionsManager.getInstance().getOptions().getEditorOptions().setFileSizeVisible(state);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        ImageComponentDecorator decorator = (ImageComponentDecorator)ImageComponentDecorator.DATA_KEY.getData(e.getDataContext());
        e.getPresentation().setEnabled(decorator != null && decorator.isEnabledForActionPlace(e.getPlace()));
        e.getPresentation().setText(this.isSelected(e) ? "Hide File Size" : "Show File Size");
    }
}

