/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import org.intellij.lang.regexp.AsciiUtil;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RegExpLanguageHost {
    public static final EnumSet<RegExpGroup.Type> EMPTY_NAMED_GROUP_TYPES = EnumSet.noneOf(RegExpGroup.Type.class);
    public static final String[][] EMPTY_COMPLETION_ITEMS_ARRAY = new String[0][];

    public boolean characterNeedsEscaping(char var1);

    public boolean supportsPerl5EmbeddedComments();

    public boolean supportsPossessiveQuantifiers();

    public boolean supportsPythonConditionalRefs();

    public boolean supportsNamedGroupSyntax(RegExpGroup var1);

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef var1);

    @NotNull
    default public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        return EMPTY_NAMED_GROUP_TYPES;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar var1);

    default public boolean isValidGroupName(String name, @NotNull RegExpGroup group) {
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (AsciiUtil.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    default public boolean supportsSimpleClass(RegExpSimpleClass simpleClass) {
        return true;
    }

    default public boolean supportsNamedCharacters(RegExpNamedCharacter namedCharacter) {
        return false;
    }

    default public boolean isValidNamedCharacter(RegExpNamedCharacter namedCharacter) {
        return this.supportsNamedCharacters(namedCharacter);
    }

    default public boolean supportsBoundary(RegExpBoundary boundary) {
        switch (boundary.getType()) {
            case UNICODE_EXTENDED_GRAPHEME: {
                return false;
            }
        }
        return true;
    }

    default public boolean supportsLiteralBackspace(RegExpChar aChar) {
        return true;
    }

    default public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        return true;
    }

    public boolean isValidCategory(@NotNull String var1);

    default public boolean isValidPropertyValue(@NotNull String propertyName, @NotNull String value) {
        return true;
    }

    @NotNull
    public String[][] getAllKnownProperties();

    @Nullable
    public String getPropertyDescription(@Nullable String var1);

    @NotNull
    public String[][] getKnownCharacterClasses();

    @Nullable
    default public Number getQuantifierValue(@NotNull RegExpNumber number) {
        return Double.parseDouble(number.getText());
    }

    default public Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        return Lookbehind.FULL;
    }

    @NotNull
    default public String[][] getAllPropertyValues(@NotNull String propertyName) {
        return EMPTY_COMPLETION_ITEMS_ARRAY;
    }

    public static enum Lookbehind {
        NOT_SUPPORTED,
        FIXED_LENGTH_ALTERNATION,
        VARIABLE_LENGTH_ALTERNATION,
        FINITE_REPETITION,
        FULL;

    }
}

