/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AnonymousGroupInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Anonymous capturing group or numeric back reference";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new AnonymousGroupVisitor(holder);
    }

    private static class AnonymousGroupVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        AnonymousGroupVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpGroup(RegExpGroup group) {
            if (group.getType() != RegExpGroup.Type.CAPTURING_GROUP) {
                return;
            }
            Collection<RegExpGroup.Type> types = RegExpLanguageHosts.getInstance().getSupportedNamedGroupTypes(group);
            if (types.isEmpty()) {
                return;
            }
            this.myHolder.registerProblem(group.getFirstChild(), "Anonymous capturing group", new LocalQuickFix[0]);
        }

        @Override
        public void visitRegExpBackref(RegExpBackref backref) {
            Collection<RegExpGroup.Type> types = RegExpLanguageHosts.getInstance().getSupportedNamedGroupTypes(backref);
            if (types.isEmpty()) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)backref, "Numeric back reference", new LocalQuickFix[0]);
        }
    }
}

