/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EmptyAlternationBranchInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Empty branch in alternation";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new EmptyAlternationBranchVisitor(holder);
    }

    private static class DuplicateAlternationBranchFix
    implements LocalQuickFix {
        private DuplicateAlternationBranchFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Remove empty branch";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element.getParent() instanceof RegExpPattern)) {
                return;
            }
            element.getNextSibling().delete();
            element.delete();
        }
    }

    private static class EmptyAlternationBranchVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        EmptyAlternationBranchVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches = pattern.getBranches();
            if (branches.length < 2) {
                return;
            }
            boolean emptyBranchSeen = false;
            for (int i = 0; i < branches.length; ++i) {
                RegExpBranch branch = branches[i];
                if (branch.getAtoms().length > 0) continue;
                if (i == 0) {
                    emptyBranchSeen = true;
                    continue;
                }
                if (!emptyBranchSeen && i == branches.length - 1) continue;
                this.myHolder.registerProblem(branch.getPrevSibling(), "Empty branch in alternation", new LocalQuickFix[]{new DuplicateAlternationBranchFix()});
            }
        }
    }
}

