/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReDoSInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Exponential backtracking";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new ReDoSVisitor(holder);
    }

    private static class ReDoSVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        ReDoSVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpClosure(RegExpClosure closure) {
            if (!ReDoSVisitor.hasSuspiciousQuantifier(closure)) {
                return;
            }
            RegExpClosure parent = (RegExpClosure)PsiTreeUtil.getParentOfType((PsiElement)closure, RegExpClosure.class);
            while (parent != null) {
                if (ReDoSVisitor.hasSuspiciousQuantifier(parent)) {
                    if (ReDoSVisitor.isAtomic(closure)) {
                        return;
                    }
                    this.myHolder.registerProblem((PsiElement)parent, "Potential exponential backtracking", new LocalQuickFix[0]);
                    return;
                }
                parent = (RegExpClosure)PsiTreeUtil.getParentOfType((PsiElement)parent, RegExpClosure.class);
            }
        }

        private static boolean hasSuspiciousQuantifier(RegExpClosure closure) {
            RegExpQuantifier quantifier = closure.getQuantifier();
            if (!quantifier.isCounted()) {
                ASTNode token = quantifier.getToken();
                return token != null && token.getElementType() != RegExpTT.QUEST;
            }
            RegExpNumber max = quantifier.getMax();
            if (max == null) {
                return true;
            }
            Number value = max.getValue();
            return value == null || value.doubleValue() >= 10.0;
        }

        private static boolean isAtomic(RegExpAtom element) {
            while (element != null) {
                RegExpGroup group;
                RegExpClosure closure;
                if (element instanceof RegExpClosure ? (closure = (RegExpClosure)element).getQuantifier().isPossessive() : element instanceof RegExpGroup && (group = (RegExpGroup)element).getType() == RegExpGroup.Type.ATOMIC) {
                    return true;
                }
                element = (RegExpAtom)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{RegExpClosure.class, RegExpGroup.class});
            }
            return false;
        }
    }
}

