/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.xml.util.XmlStringUtil;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpReplacementUtil {
    private RegExpReplacementUtil() {
    }

    public static void replaceInContext(@NotNull PsiElement element, @NotNull String text) {
        PsiFile file2 = element.getContainingFile();
        text = RegExpReplacementUtil.escapeForContext(text, file2);
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(file2);
        assert (document != null);
        TextRange replaceRange = element.getTextRange();
        document.replaceString(replaceRange.getStartOffset(), replaceRange.getEndOffset(), (CharSequence)text);
    }

    private static String escapeForContext(String text, PsiFile file2) {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)file2.getProject());
        if (injectedLanguageManager.isInjectedFragment(file2)) {
            PsiElement copy;
            PsiElement newElement;
            ElementManipulator manipulator;
            PsiElement context = file2.getContext();
            ElementManipulator elementManipulator = manipulator = context == null ? null : ElementManipulators.getManipulator((PsiElement)context);
            if (manipulator != null && (newElement = manipulator.handleContentChange(copy = context.copy(), text)) != null) {
                String newElementText = newElement.getText();
                TextRange newRange = manipulator.getRangeInElement(newElement);
                return newElementText.substring(newRange.getStartOffset(), newRange.getEndOffset());
            }
            if (RegExpElementImpl.isLiteralExpression(context)) {
                return StringUtil.escapeStringCharacters((String)text);
            }
            if (context instanceof XmlElement) {
                return XmlStringUtil.escapeString((String)text);
            }
        }
        return text;
    }
}

