/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepeatedSpaceInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Consecutive spaces";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new RepeatedSpaceVisitor(holder);
    }

    private static class RepeatedSpaceFix
    implements LocalQuickFix {
        private final int myCount;

        RepeatedSpaceFix(int count) {
            this.myCount = count;
        }

        @Nls
        @NotNull
        public String getName() {
            return "Replace with ' {" + this.myCount + "}'";
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace with space and repeated quantifier";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof RegExpBranch)) {
                return;
            }
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject());
            TextRange range2 = descriptor.getTextRangeInElement();
            StringBuilder text = new StringBuilder();
            boolean inserted = false;
            for (PsiElement child2 = element.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
                if (!range2.contains(child2.getStartOffsetInParent())) {
                    text.append(injectedLanguageManager.getUnescapedText(child2));
                    continue;
                }
                if (inserted) continue;
                text.append(" {").append(this.myCount).append('}');
                inserted = true;
            }
            RegExpReplacementUtil.replaceInContext(element, text.toString());
        }
    }

    private static class RepeatedSpaceVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        RepeatedSpaceVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar aChar) {
            if (!RepeatedSpaceVisitor.isSpace(aChar) || RepeatedSpaceVisitor.isSpace(aChar.getPrevSibling()) || RepeatedSpaceVisitor.isInEscapeSequence(aChar)) {
                return;
            }
            PsiElement parent = aChar.getParent();
            if (parent instanceof RegExpClass || parent instanceof RegExpCharRange) {
                return;
            }
            int count = 1;
            int length = aChar.getTextLength();
            PsiElement next = aChar.getNextSibling();
            while (RepeatedSpaceVisitor.isSpace(next)) {
                ++count;
                length += next.getTextLength();
                next = next.getNextSibling();
            }
            if (count > 1) {
                String message = count + " consecutive spaces in RegExp";
                int offset = aChar.getStartOffsetInParent();
                this.myHolder.registerProblem(parent, new TextRange(offset, offset + length), message, new LocalQuickFix[]{new RepeatedSpaceFix(count)});
            }
        }

        private static boolean isInEscapeSequence(RegExpChar aChar) {
            PsiElement prev2 = aChar.getPrevSibling();
            while (prev2 instanceof RegExpChar) {
                prev2 = prev2.getPrevSibling();
            }
            if (RepeatedSpaceVisitor.isEscapeSequenceStart(prev2)) {
                return true;
            }
            PsiElement parent = aChar.getParent();
            if (prev2 != null || !(parent instanceof RegExpBranch)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            return grandParent instanceof RegExpPattern && RepeatedSpaceVisitor.isEscapeSequenceStart(grandParent.getPrevSibling());
        }

        private static boolean isEscapeSequenceStart(@Nullable PsiElement element) {
            return element instanceof PsiWhiteSpace && "\\Q".equals(InjectedLanguageManager.getInstance((Project)element.getProject()).getUnescapedText(element));
        }

        private static boolean isSpace(PsiElement element) {
            if (!(element instanceof RegExpChar)) {
                return false;
            }
            RegExpChar aChar = (RegExpChar)element;
            return aChar.getType() == RegExpChar.Type.CHAR && aChar.getValue() == 32;
        }
    }
}

