/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncFileReference;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.jetbrains.annotations.NotNull;

public class RncFileReferenceManipulator
extends AbstractElementManipulator<RncFileReference> {
    public RncFileReference handleContentChange(@NotNull RncFileReference element, @NotNull TextRange range2, String newContent) throws IncorrectOperationException {
        ASTNode node = element.getNode();
        assert (node != null);
        ASTNode literal = node.findChildByType(RncTokenTypes.LITERAL);
        if (literal != null) {
            assert (range2.equals((Object)element.getReferenceRange()));
            PsiManager manager = element.getManager();
            ASTNode newChild = RenameUtil.createLiteralNode(manager, newContent);
            literal.getTreeParent().replaceChild(literal, newChild);
        }
        return element;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull RncFileReference element) {
        return element.getReferenceRange();
    }
}

