/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDecl;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RncBlock
implements Block {
    private final ASTNode myNode;

    RncBlock(ASTNode element) {
        this.myNode = element;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.myNode.getTextRange();
    }

    @NotNull
    public List<Block> getSubBlocks() {
        ArrayList<Block> list2 = new ArrayList<Block>();
        for (ASTNode node = this.myNode.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            if (RncTokenTypes.WHITESPACE.contains(node.getElementType()) || node.getTextLength() <= 0) continue;
            list2.add(new RncBlock(node));
        }
        return list2;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        if (this.myNode.getTreeParent() == null) {
            return null;
        }
        if (this.isTopLevel()) {
            return Indent.getAbsoluteNoneIndent();
        }
        if (this.myNode.getTreeParent().getPsi() instanceof RncGrammar && !RncTokenTypes.BRACES.contains(this.myNode.getElementType())) {
            return Indent.getNormalIndent();
        }
        return null;
    }

    private boolean isTopLevel() {
        PsiElement parent = this.myNode.getTreeParent().getPsi();
        return parent instanceof RncDocument || parent instanceof RncFile || parent instanceof RncGrammar && parent.getParent() instanceof RncDocument;
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child1 == null) {
            return null;
        }
        ASTNode lnode = ((RncBlock)child1).myNode;
        PsiElement lpsi = lnode.getPsi();
        PsiElement rpsi = ((RncBlock)child2).myNode.getPsi();
        if (lpsi instanceof RncDecl && rpsi instanceof RncDecl) {
            return RncBlock.makeNewline();
        }
        if ((lpsi instanceof RncDecl || lpsi instanceof RncDefine || lnode.getElementType() == RncElementTypes.START) && (rpsi instanceof RncDefine || rpsi instanceof RncGrammar)) {
            return RncBlock.makeNewline();
        }
        return null;
    }

    private static Spacing makeNewline() {
        return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)true, (int)100);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(null, null);
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return false;
    }
}

