/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;

public class RenameUtil {
    private static final Set<String> ourRncKeywords = new HashSet<String>();

    private RenameUtil() {
    }

    @NotNull
    public static ASTNode createIdentifierNode(PsiManager manager, String name) throws IncorrectOperationException {
        if (RenameUtil.isKeyword(name)) {
            name = "\\" + name;
        } else if (!RenameUtil.isIdentifier(name)) {
            throw new IncorrectOperationException("Illegal identifier: " + name);
        }
        PsiFileFactory f = PsiFileFactory.getInstance((Project)manager.getProject());
        RncFile file2 = (RncFile)f.createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)(name + " = bar"));
        ASTNode astNode = RenameUtil.findFirstGrammarNode(file2);
        ASTNode newNode = astNode.findChildByType(RncTokenTypes.IDENTIFIERS);
        assert (newNode != null);
        return newNode;
    }

    public static boolean isIdentifier(String name) {
        if (name == null) {
            return false;
        }
        return Verifier.checkXMLName((String)name) == null || name.length() >= 2 && name.charAt(0) == '\\' && Verifier.checkXMLName((String)name.substring(1)) == null;
    }

    public static boolean isKeyword(String name) {
        return ourRncKeywords.contains(name);
    }

    public static ASTNode createPrefixedNode(PsiManager manager, String prefix, String localPart) {
        PsiFileFactory f = PsiFileFactory.getInstance((Project)manager.getProject());
        RncFile file2 = (RncFile)f.createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)("element " + prefix + ":" + localPart + " { text }"));
        ASTNode node = RenameUtil.findFirstGrammarNode(file2);
        ASTNode nameClassNode = node.findChildByType(RncElementTypes.NAME_CLASS);
        assert (nameClassNode != null);
        ASTNode astNode = nameClassNode.findChildByType(RncElementTypes.NAME);
        assert (astNode != null);
        return astNode;
    }

    @NotNull
    private static ASTNode findFirstGrammarNode(RncFile file2) {
        RncGrammar grammar = file2.getGrammar();
        assert (grammar != null);
        ASTNode grammarNode = grammar.getNode();
        assert (grammarNode != null);
        ASTNode astNode = grammarNode.getFirstChildNode();
        assert (astNode != null);
        return astNode;
    }

    public static ASTNode createLiteralNode(PsiManager manager, String content) {
        PsiFileFactory f = PsiFileFactory.getInstance((Project)manager.getProject());
        RncFile file2 = (RncFile)f.createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)("include \"" + content + "\""));
        ASTNode include = RenameUtil.findFirstGrammarNode(file2);
        ASTNode literal = include.findChildByType(RncTokenTypes.LITERAL);
        assert (literal != null);
        return literal;
    }

    static {
        Collections.addAll(ourRncKeywords, "attribute", "default", "datatypes", "div", "element", "empty", "external", "grammar", "include", "inherit", "list", "mixed", "namespace", "notAllowed", "parent", "start", "string", "text", "token");
    }
}

