/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.xml.dom.impl;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.resolve.DefinitionResolver;
import org.intellij.plugins.relaxNG.xml.dom.RngDefine;
import org.intellij.plugins.relaxNG.xml.dom.RngDomVisitor;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.intellij.plugins.relaxNG.xml.dom.RngInclude;
import org.intellij.plugins.relaxNG.xml.dom.impl.DefinitionReference;
import org.jetbrains.annotations.NotNull;

public class RngReferenceConverter
implements CustomReferenceConverter {
    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        final GenericAttributeValue e = (GenericAttributeValue)genericDomValue;
        if (genericDomValue.getParent() instanceof RngDefine) {
            XmlAttributeValue value = e.getXmlAttributeValue();
            if (value == null) {
                return PsiReference.EMPTY_ARRAY;
            }
            return new PsiReference[]{new PsiReferenceBase<XmlAttributeValue>(value, true){

                public PsiElement resolve() {
                    return ((XmlAttributeValue)this.myElement).getParent().getParent();
                }

                @NotNull
                public Object[] getVariants() {
                    XmlFile file2;
                    RngInclude include = (RngInclude)e.getParentOfType(RngInclude.class, true);
                    RngGrammar scope = (RngGrammar)e.getParentOfType(RngGrammar.class, true);
                    if (scope != null && include != null && DomUtil.isAncestor((DomElement)scope, (DomElement)include, (boolean)true) && (file2 = (XmlFile)include.getIncludedFile().getValue()) != null) {
                        DomFileElement fileElement = scope.getManager().getFileElement(file2, DomElement.class);
                        if (fileElement == null) {
                            return EMPTY_ARRAY;
                        }
                        final Ref ref = new Ref((Object)ArrayUtil.EMPTY_STRING_ARRAY);
                        fileElement.acceptChildren((DomElementVisitor)new RngDomVisitor(){

                            @Override
                            public void visit(RngGrammar grammar) {
                                Map<String, Set<Define>> map2 = DefinitionResolver.getAllVariants(grammar);
                                if (map2 != null) {
                                    ref.set((Object)map2.keySet().toArray());
                                }
                            }
                        });
                        return (Object[])ref.get();
                    }
                    return ArrayUtil.EMPTY_STRING_ARRAY;
                }
            }};
        }
        return new PsiReference[]{new DefinitionReference((GenericAttributeValue<String>)e)};
    }
}

