/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AsyncValueLoader<T> {
    private final AtomicReference<Promise<T>> ref = new AtomicReference();
    private volatile long modificationCount;
    private volatile long loadedModificationCount;
    private final Consumer<T> doneHandler = new Consumer<T>(){

        @Override
        public void accept(T o) {
            AsyncValueLoader.this.loadedModificationCount = AsyncValueLoader.this.modificationCount;
        }
    };

    @NotNull
    public final Promise<T> get() {
        return this.get(true);
    }

    public final T getResultIfFullFilled() {
        Promise<T> result2 = this.ref.get();
        try {
            return (T)(result2 != null && result2.isSucceeded() ? result2.blockingGet(0) : null);
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
    }

    public final void reset() {
        Promise oldValue = this.ref.getAndSet(null);
        if (oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    private void rejectAndDispose(@NotNull AsyncPromise<T> asyncResult) {
        Object result2;
        if (asyncResult.setError("rejected")) {
            return;
        }
        try {
            result2 = asyncResult.blockingGet(0);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        if (result2 != null) {
            this.disposeResult(result2);
        }
    }

    protected void disposeResult(@NotNull T result2) {
        if (result2 instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)result2), (boolean)false);
        }
    }

    @NotNull
    public final Promise<T> get(boolean checkFreshness) {
        AsyncPromise promise = this.ref.get();
        if (promise == null) {
            promise = new AsyncPromise();
            if (!this.ref.compareAndSet((Promise<T>)null, (Promise<T>)promise)) {
                return this.ref.get();
            }
        } else {
            Promise.State state = promise.getState();
            if (state == Promise.State.PENDING) {
                return promise;
            }
            if (state == Promise.State.SUCCEEDED) {
                if (!checkFreshness || this.isUpToDate()) {
                    return promise;
                }
                if (!this.ref.compareAndSet((Promise<T>)promise, (Promise<T>)(promise = new AsyncPromise()))) {
                    Promise<T> valueFromAnotherThread = this.ref.get();
                    while (valueFromAnotherThread == null) {
                        if (this.ref.compareAndSet((Promise<T>)null, (Promise<T>)promise)) {
                            return this.getPromise(promise);
                        }
                        valueFromAnotherThread = this.ref.get();
                    }
                    return valueFromAnotherThread;
                }
            }
        }
        return this.getPromise(promise);
    }

    protected boolean isCancelOnReject() {
        return false;
    }

    @NotNull
    private Promise<T> getPromise(@NotNull AsyncPromise<T> promise) {
        Promise<T> effectivePromise;
        try {
            effectivePromise = this.load(promise);
            if (effectivePromise != promise) {
                this.ref.compareAndSet((Promise<T>)promise, effectivePromise);
            }
        }
        catch (Throwable e) {
            this.ref.compareAndSet((Promise<T>)promise, (Promise<T>)null);
            this.rejectAndDispose(promise);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        effectivePromise.onSuccess(this.doneHandler);
        if (this.isCancelOnReject()) {
            effectivePromise.onError(throwable -> this.ref.compareAndSet(effectivePromise, null));
        }
        if (effectivePromise != promise) {
            effectivePromise.processed(promise);
        }
        return effectivePromise;
    }

    @NotNull
    protected abstract Promise<T> load(@NotNull AsyncPromise<T> var1) throws IOException;

    private boolean isUpToDate() {
        return this.loadedModificationCount == this.modificationCount;
    }

    public final void set(@NotNull T result2) {
        Promise oldValue = this.ref.getAndSet(Promises.resolvedPromise(result2));
        if (oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    public final void markDirty() {
        ++this.modificationCount;
    }
}

