/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.concurrency.AtomicFieldUpdater;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class PromiseManager<HOST, VALUE> {
    private final AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater;

    public PromiseManager(@NotNull AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater) {
        this.fieldUpdater = fieldUpdater;
    }

    public PromiseManager(@NotNull Class<HOST> ownerClass) {
        this.fieldUpdater = AtomicFieldUpdater.forFieldOfType(ownerClass, Promise.class);
    }

    public boolean isUpToDate(@NotNull HOST host, @NotNull VALUE value) {
        return true;
    }

    @NotNull
    public abstract Promise<VALUE> load(@NotNull HOST var1);

    public final void reset(HOST host) {
        this.fieldUpdater.set(host, null);
    }

    public final void set(HOST host, @Nullable VALUE value) {
        if (value == null) {
            this.reset(host);
        } else {
            ((AsyncPromise)this.getOrCreateAsyncResult(host, false, false)).setResult(value);
        }
    }

    public final boolean has(HOST host) {
        Promise result2 = (Promise)this.fieldUpdater.get(host);
        return result2 != null && result2.isSucceeded();
    }

    @Nullable
    public final Promise.State getState(HOST host) {
        Promise result2 = (Promise)this.fieldUpdater.get(host);
        return result2 == null ? null : result2.getState();
    }

    @NotNull
    public final Promise<VALUE> get(HOST host) {
        return this.get(host, true);
    }

    @NotNull
    public final Promise<VALUE> get(HOST host, boolean checkFreshness) {
        return this.getOrCreateAsyncResult(host, checkFreshness, true);
    }

    @NotNull
    private Promise<VALUE> getOrCreateAsyncResult(HOST host, boolean checkFreshness, boolean load2) {
        Promise promise = (Promise)this.fieldUpdater.get(host);
        if (promise == null) {
            promise = new AsyncPromise();
            if (!this.fieldUpdater.compareAndSet(host, null, (Object)promise)) {
                return (Promise)this.fieldUpdater.get(host);
            }
        } else {
            Promise.State state = promise.getState();
            if (state == Promise.State.PENDING) {
                return promise;
            }
            if (state == Promise.State.SUCCEEDED) {
                try {
                    if (!checkFreshness || this.isUpToDate(host, promise.blockingGet(0))) {
                        return promise;
                    }
                }
                catch (ExecutionException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
                Promise promise2 = promise;
                promise = new AsyncPromise();
                if (!this.fieldUpdater.compareAndSet(host, (Object)promise2, (Object)promise)) {
                    Promise valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    while (valueFromAnotherThread == null) {
                        if (this.fieldUpdater.compareAndSet(host, null, (Object)promise)) {
                            return this.getPromise(host, load2, promise);
                        }
                        valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    }
                    return valueFromAnotherThread;
                }
            }
        }
        return this.getPromise(host, load2, promise);
    }

    @NotNull
    private Promise<VALUE> getPromise(HOST host, boolean load2, Promise<VALUE> promise) {
        if (!load2 || promise.getState() != Promise.State.PENDING) {
            return promise;
        }
        Promise<VALUE> effectivePromise = this.load(host);
        if (effectivePromise != promise) {
            this.fieldUpdater.compareAndSet(host, promise, effectivePromise);
            effectivePromise.processed(promise);
        }
        return effectivePromise;
    }
}

