/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.CustomPropertiesValuePresentation$WhenMappings;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/debugger/CustomPropertiesValuePresentation;", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "value", "Lorg/jetbrains/debugger/values/ObjectValue;", "properties", "", "Lorg/jetbrains/debugger/Variable;", "(Lorg/jetbrains/debugger/values/ObjectValue;Ljava/util/List;)V", "renderValue", "", "renderer", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation$XValueTextRenderer;", "intellij.platform.scriptDebugger.ui"})
public final class CustomPropertiesValuePresentation
extends XValuePresentation {
    private final ObjectValue value;
    private final List<Variable> properties;

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer2) {
        renderer2.renderComment(VariableViewKt.getObjectValueDescription(this.value));
        renderer2.renderSpecialSymbol(" {");
        boolean isFirst = true;
        block7: for (Variable property : this.properties) {
            Value value;
            if (isFirst) {
                isFirst = false;
            } else {
                renderer2.renderSpecialSymbol(", ");
            }
            renderer2.renderValue(property.getName(), DefaultLanguageHighlighterColors.INSTANCE_FIELD);
            renderer2.renderSpecialSymbol(": ");
            if (property.getValue() == null) {
                Intrinsics.throwNpe();
            }
            switch (CustomPropertiesValuePresentation$WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    String string = value.getValueString();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    renderer2.renderKeywordValue(string);
                    continue block7;
                }
                case 5: 
                case 6: {
                    String string = value.getValueString();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    renderer2.renderNumericValue(string);
                    continue block7;
                }
                case 7: {
                    String string;
                    String string2 = string = value.getValueString();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    renderer2.renderStringValue(string2, "\"\\", 1000);
                    Value value2 = value;
                    if (!(value2 instanceof StringValue)) {
                        value2 = null;
                    }
                    StringValue stringValue = (StringValue)value2;
                    int actualStringLength = stringValue != null ? stringValue.getLength() : string.length();
                    if (actualStringLength <= 1000) continue block7;
                    renderer2.renderComment(XDebuggerBundle.message((String)"node.text.ellipsis.truncated", (Object[])new Object[]{actualStringLength}));
                    continue block7;
                }
                case 8: {
                    renderer2.renderComment(VariableViewKt.trimFunctionDescription(value));
                    continue block7;
                }
                case 9: {
                    Value value3 = value;
                    if (value3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
                    }
                    renderer2.renderComment(VariableViewKt.getObjectValueDescription((ObjectValue)value3));
                    continue block7;
                }
            }
            String string = value.getValueString();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            renderer2.renderValue(string);
        }
        renderer2.renderSpecialSymbol("}");
    }

    public CustomPropertiesValuePresentation(@NotNull ObjectValue value, @NotNull List<? extends Variable> properties) {
        this.value = value;
        this.properties = properties;
    }
}

