/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.NonWatchableVariableContext;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.VariablesGroup;
import org.jetbrains.debugger.VariablesKt;
import org.jetbrains.debugger.VariablesKt$processVariables$;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a>\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000bH\u0002\u001a6\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a*\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u001a\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\f\u001a\u00020\r\u001a\u001c\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0002\u001aD\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#\u001a,\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010(\u001a\u00020#\u001an\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070%2\u0006\u0010 \u001a\u00020\u00172\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00120%2\u0006\u0010*\u001a\u00020+2<\u0010,\u001a8\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(\f\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00020\u0012\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00070-\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"NATURAL_NAME_COMPARATOR", "Ljava/util/Comparator;", "Lorg/jetbrains/debugger/Variable;", "UNNAMED_FUNCTION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "addAditionalVariables", "", "additionalVariables", "", "result", "", "memberFilter", "Lorg/jetbrains/debugger/MemberFilter;", "functions", "createVariablesList", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "variables", "", "from", "", "to", "variableContext", "Lorg/jetbrains/debugger/VariableContext;", "filterAndSort", "naturalCompare", "string1", "", "string2", "processNamedObjectProperties", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "context", "maxChildrenToAdd", "defaultIsLast", "", "processScopeVariables", "Lorg/jetbrains/concurrency/Promise;", "scope", "Lorg/jetbrains/debugger/Scope;", "isLast", "processVariables", "obsolescent", "Lorg/jetbrains/concurrency/Obsolescent;", "consumer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "intellij.platform.scriptDebugger.ui"})
public final class VariablesKt {
    private static final Pattern UNNAMED_FUNCTION_PATTERN = Pattern.compile("^function[\\t ]*\\(");
    private static final Comparator<Variable> NATURAL_NAME_COMPARATOR = NATURAL_NAME_COMPARATOR.1.INSTANCE;

    @NotNull
    public static final Promise<Unit> processVariables(@NotNull VariableContext context, @NotNull Promise<List<Variable>> variables, @NotNull Obsolescent obsolescent, @NotNull Function2<? super MemberFilter, ? super List<? extends Variable>, Unit> consumer) {
        Promise<MemberFilter> $receiver$iv = context.getMemberFilter();
        boolean $i$f$thenAsync = false;
        return $receiver$iv.thenAsync((Function)new ValueNodeAsyncFunction<MemberFilter, Unit>(obsolescent, obsolescent, variables, obsolescent, consumer){
            final /* synthetic */ Obsolescent $node;
            final /* synthetic */ Promise $variables$inlined;
            final /* synthetic */ Obsolescent $obsolescent$inlined;
            final /* synthetic */ Function2 $consumer$inlined;
            {
                this.$node = $captured_local_variable$1;
                this.$variables$inlined = promise;
                this.$obsolescent$inlined = obsolescent;
                this.$consumer$inlined = function2;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            @NotNull
            public Promise fun(Object param) {
                void $receiver$iv;
                MemberFilter memberFilter = (MemberFilter)param;
                boolean bl = false;
                Promise promise = this.$variables$inlined;
                Obsolescent obsolescent$iv = this.$obsolescent$inlined;
                boolean $i$f$then = false;
                return $receiver$iv.then((Function)new ObsolescentFunction<List<? extends Variable>, Unit>(obsolescent$iv, memberFilter, this){
                    final /* synthetic */ Obsolescent $obsolescent;
                    final /* synthetic */ MemberFilter $memberFilter$inlined;
                    final /* synthetic */ processVariables$$inlined$thenAsync$1 this$0;
                    {
                        this.$obsolescent = $captured_local_variable$1;
                        this.$memberFilter$inlined = memberFilter;
                        this.this$0 = var3_3;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object fun(Object param) {
                        List it = (List)param;
                        boolean bl = false;
                        this.this$0.$consumer$inlined.invoke((Object)this.$memberFilter$inlined, (Object)it);
                        return Unit.INSTANCE;
                    }

                    public boolean isObsolete() {
                        return this.$obsolescent.isObsolete();
                    }
                });
            }
        });
    }

    @NotNull
    public static final Promise<Unit> processScopeVariables(@NotNull Scope scope, @NotNull XCompositeNode node, @NotNull VariableContext context, boolean isLast) {
        return VariablesKt.processVariables(context, scope.getVariablesHost().get(), (Obsolescent)node, (Function2<? super MemberFilter, ? super List<? extends Variable>, Unit>)((Function2)new Function2<MemberFilter, List<? extends Variable>, Unit>(context, node, isLast){
            final /* synthetic */ VariableContext $context;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ boolean $isLast;

            public final void invoke(@NotNull MemberFilter memberFilter, @NotNull List<? extends Variable> variables) {
                Collection<Variable> additionalVariables = memberFilter.getAdditionalVariables();
                Object object = this.$context.getVm();
                Value exceptionValue = object != null && (object = object.getSuspendContextManager()) != null && (object = object.getContext()) != null && (object = object.getExceptionData()) != null ? object.getExceptionValue() : null;
                ArrayList<Variable> properties = new ArrayList<Variable>(variables.size() + additionalVariables.size() + (exceptionValue == null ? 0 : 1));
                Value value = exceptionValue;
                if (value != null) {
                    Value value2;
                    Value value3 = value2 = value;
                    boolean bl = false;
                    properties.add(new VariableImpl("Exception", value3));
                }
                SmartList functions = new SmartList();
                for (Variable variable : variables) {
                    if (!memberFilter.isMemberVisible(variable) || !(Intrinsics.areEqual((Object)variable.getName(), (Object)"this") ^ true) || !(Intrinsics.areEqual((Object)variable.getName(), (Object)memberFilter.sourceNameToRaw("this")) ^ true)) continue;
                    Value value3 = variable.getValue();
                    if (value3 != null && value3.getType() == ValueType.FUNCTION && value3.getValueString() != null && !VariablesKt.access$getUNNAMED_FUNCTION_PATTERN$p().matcher(value3.getValueString()).lookingAt()) {
                        functions.add((Object)variable);
                        continue;
                    }
                    properties.add(variable);
                }
                VariablesKt.addAditionalVariables$default(additionalVariables, properties, memberFilter, null, 8, null);
                Comparator comparator2 = memberFilter.hasNameMappings() ? (Comparator)new Comparator<Variable>(memberFilter){
                    final /* synthetic */ MemberFilter $memberFilter;

                    public final int compare(Variable o1, Variable o2) {
                        return VariablesKt.access$naturalCompare(this.$memberFilter.rawNameToSource(o1), this.$memberFilter.rawNameToSource(o2));
                    }
                    {
                        this.$memberFilter = memberFilter;
                    }
                } : VariablesKt.access$getNATURAL_NAME_COMPARATOR$p();
                CollectionsKt.sortWith((List)properties, (Comparator)comparator2);
                CollectionsKt.sortWith((List)((List)functions), (Comparator)comparator2);
                if (!properties.isEmpty()) {
                    this.$node.addChildren(VariablesKt.createVariablesList((List<? extends Variable>)properties, this.$context, memberFilter), functions.isEmpty() && this.$isLast);
                }
                if (!functions.isEmpty()) {
                    this.$node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new VariablesGroup("Functions", (List)functions, this.$context)), this.$isLast);
                } else if (this.$isLast && properties.isEmpty()) {
                    this.$node.addChildren(XValueChildrenList.EMPTY, true);
                }
            }
            {
                this.$context = variableContext;
                this.$node = xCompositeNode;
                this.$isLast = bl;
                super(2);
            }
        }));
    }

    @Nullable
    public static final List<Variable> processNamedObjectProperties(@NotNull List<? extends Variable> variables, @NotNull XCompositeNode node, @NotNull VariableContext context, @NotNull MemberFilter memberFilter, int maxChildrenToAdd, boolean defaultIsLast) {
        List<Variable> list2 = VariablesKt.filterAndSort(variables, memberFilter);
        if (list2.isEmpty()) {
            if (defaultIsLast) {
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
            return null;
        }
        int to = Math.min(maxChildrenToAdd, list2.size());
        boolean isLast = to == list2.size();
        node.addChildren(VariablesKt.createVariablesList(list2, 0, to, context, memberFilter), defaultIsLast && isLast);
        if (isLast) {
            return null;
        }
        node.tooManyChildren(list2.size() - to);
        return list2;
    }

    @NotNull
    public static final List<Variable> filterAndSort(@NotNull List<? extends Variable> variables, @NotNull MemberFilter memberFilter) {
        if (variables.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Collection<Variable> additionalVariables = memberFilter.getAdditionalVariables();
        ArrayList<Variable> result2 = new ArrayList<Variable>(variables.size() + additionalVariables.size());
        for (Variable variable : variables) {
            if (!memberFilter.isMemberVisible(variable)) continue;
            result2.add(variable);
        }
        CollectionsKt.sortWith((List)result2, NATURAL_NAME_COMPARATOR);
        VariablesKt.addAditionalVariables$default(additionalVariables, result2, memberFilter, null, 8, null);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addAditionalVariables(Collection<? extends Variable> additionalVariables, List<Variable> result2, MemberFilter memberFilter, List<Variable> functions) {
        int oldSize = result2.size();
        block0: for (Variable variable : additionalVariables) {
            if (!memberFilter.isMemberVisible(variable)) continue;
            int n = 0;
            int n2 = oldSize - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    Variable vmVariable;
                    if (Intrinsics.areEqual((Object)memberFilter.rawNameToSource(vmVariable = result2.get((int)i)), (Object)memberFilter.rawNameToSource(variable))) {
                        Value vmValue = vmVariable.getValue();
                        if (vmValue != null) {
                            variable.setValue(vmValue);
                        }
                        result2.set((int)i, variable);
                        continue block0;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (functions != null) {
                for (Variable function : functions) {
                    if (!Intrinsics.areEqual((Object)memberFilter.rawNameToSource(function), (Object)memberFilter.rawNameToSource(variable))) continue;
                    continue block0;
                }
            }
            result2.add(variable);
        }
    }

    static /* synthetic */ void addAditionalVariables$default(Collection collection, List list2, MemberFilter memberFilter, List list3, int n, Object object) {
        if ((n & 8) != 0) {
            list3 = null;
        }
        VariablesKt.addAditionalVariables(collection, list2, memberFilter, list3);
    }

    private static final int naturalCompare(String string1, String string2) {
        int j;
        if (string1 == string2) {
            return 0;
        }
        if (string1 == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        int string1Length = string1.length();
        int string2Length = string2.length();
        int i = 0;
        for (j = 0; i < string1Length && j < string2Length; ++i, ++j) {
            char ch1 = string1.charAt(i);
            char ch2 = string2.charAt(j);
            if ((StringUtil.isDecimalDigit((char)ch1) || ch1 == ' ') && (StringUtil.isDecimalDigit((char)ch2) || ch2 == ' ')) {
                int startNum1 = i;
                while ((ch1 == ' ' || ch1 == '0') && ++startNum1 < string1Length) {
                    ch1 = string1.charAt(startNum1);
                }
                int startNum2 = j;
                while ((ch2 == ' ' || ch2 == '0') && ++startNum2 < string2Length) {
                    ch2 = string2.charAt(startNum2);
                }
                j = startNum2;
                for (i = startNum1; i < string1Length && StringUtil.isDecimalDigit((char)string1.charAt(i)); ++i) {
                }
                while (j < string2Length && StringUtil.isDecimalDigit((char)string2.charAt(j))) {
                    ++j;
                }
                int lengthDiff = i - startNum1 - (j - startNum2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                while (startNum1 < i) {
                    int diff = string1.charAt(startNum1) - string2.charAt(startNum2);
                    if (diff != 0) {
                        return diff;
                    }
                    ++startNum1;
                    ++startNum2;
                }
                --i;
                --j;
                continue;
            }
            if (ch1 == ch2) continue;
            naturalCompare.1 reverseCase$ = naturalCompare.1.INSTANCE;
            if (ch1 == '_') {
                return 1;
            }
            if (ch2 == '_') {
                return -1;
            }
            return reverseCase$.invoke(ch1) - reverseCase$.invoke(ch2);
        }
        if (i < string1Length) {
            return 1;
        }
        if (j < string2Length) {
            return -1;
        }
        return string1Length - string2Length;
    }

    @JvmOverloads
    @NotNull
    public static final XValueChildrenList createVariablesList(@NotNull List<? extends Variable> variables, @NotNull VariableContext variableContext, @Nullable MemberFilter memberFilter) {
        return VariablesKt.createVariablesList(variables, 0, variables.size(), variableContext, memberFilter);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ XValueChildrenList createVariablesList$default(List list2, VariableContext variableContext, MemberFilter memberFilter, int n, Object object) {
        if ((n & 4) != 0) {
            memberFilter = null;
        }
        return VariablesKt.createVariablesList(list2, variableContext, memberFilter);
    }

    @JvmOverloads
    @NotNull
    public static final XValueChildrenList createVariablesList(@NotNull List<? extends Variable> variables, @NotNull VariableContext variableContext) {
        return VariablesKt.createVariablesList$default(variables, variableContext, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final XValueChildrenList createVariablesList(@NotNull List<? extends Variable> variables, int from, int to, @NotNull VariableContext variableContext, @Nullable MemberFilter memberFilter) {
        XValueChildrenList list2 = new XValueChildrenList(to - from);
        VariableContext getterOrSetterContext = null;
        int n = from;
        int n2 = to;
        while (n < n2) {
            void i;
            Variable variable = variables.get((int)i);
            Object object = memberFilter;
            if (object == null || (object = object.rawNameToSource(variable)) == null) {
                object = variable.getName();
            }
            Object normalizedName = object;
            list2.add((XNamedValue)new VariableView((String)normalizedName, variable, variableContext));
            if (variable instanceof ObjectProperty) {
                if (((ObjectProperty)variable).getGetter() != null) {
                    if (getterOrSetterContext == null) {
                        getterOrSetterContext = new NonWatchableVariableContext(variableContext);
                    }
                    String string = "get " + (String)normalizedName;
                    FunctionValue functionValue = ((ObjectProperty)variable).getGetter();
                    if (functionValue == null) {
                        Intrinsics.throwNpe();
                    }
                    list2.add((XNamedValue)VariableViewKt.VariableView(new VariableImpl(string, functionValue), getterOrSetterContext));
                }
                if (((ObjectProperty)variable).getSetter() != null) {
                    if (getterOrSetterContext == null) {
                        getterOrSetterContext = new NonWatchableVariableContext(variableContext);
                    }
                    String string = "set " + (String)normalizedName;
                    FunctionValue functionValue = ((ObjectProperty)variable).getSetter();
                    if (functionValue == null) {
                        Intrinsics.throwNpe();
                    }
                    list2.add((XNamedValue)VariableViewKt.VariableView(new VariableImpl(string, functionValue), getterOrSetterContext));
                }
            }
            ++i;
        }
        return list2;
    }

    public static final /* synthetic */ Pattern access$getUNNAMED_FUNCTION_PATTERN$p() {
        return UNNAMED_FUNCTION_PATTERN;
    }

    public static final /* synthetic */ int access$naturalCompare(String string1, String string2) {
        return VariablesKt.naturalCompare(string1, string2);
    }

    public static final /* synthetic */ Comparator access$getNATURAL_NAME_COMPARATOR$p() {
        return NATURAL_NAME_COMPARATOR;
    }
}

