/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 +2\u00020\u0001:\u0001+BA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0006J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u001d\u0010 \u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020$J\u0010\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010'\u001a\u00020\u0018J\u0010\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010#\u001a\u00020$J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\bJ\u0010\u0010*\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020$R!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "", "rawSources", "", "", "trimFileScheme", "", "baseUrl", "Lcom/intellij/util/Url;", "sourceContents", "baseUrlIsFile", "(Ljava/util/List;ZLcom/intellij/util/Url;Ljava/util/List;Z)V", "canonicalizedUrlToSourceIndex", "Lcom/intellij/util/containers/ObjectIntHashMap;", "getCanonicalizedUrlToSourceIndex", "()Lcom/intellij/util/containers/ObjectIntHashMap;", "canonicalizedUrlToSourceIndex$delegate", "Lkotlin/Lazy;", "canonicalizedUrls", "", "getCanonicalizedUrls", "()[Lcom/intellij/util/Url;", "canonicalizedUrls$delegate", "findSourceIndex", "", "sourceUrl", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "localFileUrlOnly", "resolver", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "findSourceIndex$intellij_platform_scriptDebugger_backend", "findSourceIndexByFile", "findSourceIndexByFile$intellij_platform_scriptDebugger_backend", "getRawSource", "entry", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getSource", "getSourceContent", "sourceIndex", "getSourceIndex", "url", "getUrlIfLocalFile", "Companion", "intellij.platform.scriptDebugger.backend"})
public final class SourceResolver {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Lazy canonicalizedUrls$delegate;
    private final Lazy canonicalizedUrlToSourceIndex$delegate;
    private final List<String> rawSources;
    private final List<String> sourceContents;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SourceResolver.class), "canonicalizedUrls", "getCanonicalizedUrls()[Lcom/intellij/util/Url;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SourceResolver.class), "canonicalizedUrlToSourceIndex", "getCanonicalizedUrlToSourceIndex()Lcom/intellij/util/containers/ObjectIntHashMap;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final Url[] getCanonicalizedUrls() {
        Lazy lazy = this.canonicalizedUrls$delegate;
        SourceResolver sourceResolver = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Url[])lazy.getValue();
    }

    private final ObjectIntHashMap<Url> getCanonicalizedUrlToSourceIndex() {
        Lazy lazy = this.canonicalizedUrlToSourceIndex$delegate;
        SourceResolver sourceResolver = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (ObjectIntHashMap)lazy.getValue();
    }

    @Nullable
    public final Url getSource(@NotNull MappingEntry entry) {
        int index = entry.getSource();
        return index < 0 ? null : this.getCanonicalizedUrls()[index];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getSourceContent(@NotNull MappingEntry entry) {
        if (UtilKt.isNullOrEmpty((Collection)this.sourceContents)) {
            return null;
        }
        int index = entry.getSource();
        if (index < 0) return null;
        List<String> list2 = this.sourceContents;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        if (index >= list2.size()) {
            return null;
        }
        String string = this.sourceContents.get(index);
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getSourceContent(int sourceIndex) {
        if (UtilKt.isNullOrEmpty((Collection)this.sourceContents)) {
            return null;
        }
        if (sourceIndex < 0) return null;
        List<String> list2 = this.sourceContents;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        if (sourceIndex >= list2.size()) {
            return null;
        }
        String string = this.sourceContents.get(sourceIndex);
        return string;
    }

    public final int getSourceIndex(@NotNull Url url) {
        return this.getCanonicalizedUrlToSourceIndex().get((Object)url);
    }

    @Nullable
    public final String getRawSource(@NotNull MappingEntry entry) {
        int index = entry.getSource();
        return index < 0 ? null : this.rawSources.get(index);
    }

    public final int findSourceIndex$intellij_platform_scriptDebugger_backend(@NotNull SourceFileResolver resolver) {
        int resolveByCanonicalizedUrls = resolver.resolve(this.getCanonicalizedUrlToSourceIndex());
        return resolveByCanonicalizedUrls != -1 ? resolveByCanonicalizedUrls : resolver.resolve(this.rawSources);
    }

    public final int findSourceIndex(@NotNull Url sourceUrl, @Nullable VirtualFile sourceFile, boolean localFileUrlOnly) {
        int index = this.getCanonicalizedUrlToSourceIndex().get((Object)sourceUrl);
        if (index != -1) {
            return index;
        }
        if (sourceFile != null) {
            return this.findSourceIndexByFile$intellij_platform_scriptDebugger_backend(sourceFile, localFileUrlOnly);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int findSourceIndexByFile$intellij_platform_scriptDebugger_backend(@NotNull VirtualFile sourceFile, boolean localFileUrlOnly) {
        int index;
        if (!localFileUrlOnly && (index = this.getCanonicalizedUrlToSourceIndex().get((Object)Urls.newFromVirtualFile(sourceFile).trimParameters())) != -1) {
            return index;
        }
        if (!sourceFile.isInLocalFileSystem()) {
            return -1;
        }
        index = this.getCanonicalizedUrlToSourceIndex().get((Object)Urls.newLocalFileUrl(sourceFile));
        if (index != -1) {
            return index;
        }
        VirtualFile canonicalFile = sourceFile.getCanonicalFile();
        if (canonicalFile != null && Intrinsics.areEqual((Object)canonicalFile, (Object)sourceFile) ^ true) {
            int n = 0;
            int n2 = this.getCanonicalizedUrls().length;
            while (n < n2) {
                void i;
                Url url = this.getCanonicalizedUrls()[i];
                if (Urls.INSTANCE.equalsIgnoreParameters(url, canonicalFile)) {
                    return (int)i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Nullable
    public final Url getUrlIfLocalFile(@NotNull MappingEntry entry) {
        Object object;
        Url url = (Url)ArraysKt.getOrNull((Object[])this.getCanonicalizedUrls(), (int)entry.getSource());
        if (url != null) {
            Url url2;
            Url it = url2 = url;
            boolean bl = false;
            object = it.isInLocalFileSystem() ? it : null;
        } else {
            object = null;
        }
        return object;
    }

    public SourceResolver(@NotNull List<String> rawSources, boolean trimFileScheme, @Nullable Url baseUrl, @Nullable List<String> sourceContents, boolean baseUrlIsFile) {
        this.rawSources = rawSources;
        this.sourceContents = sourceContents;
        this.canonicalizedUrls$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Url[]>(this, baseUrl, trimFileScheme, baseUrlIsFile){
            final /* synthetic */ SourceResolver this$0;
            final /* synthetic */ Url $baseUrl;
            final /* synthetic */ boolean $trimFileScheme;
            final /* synthetic */ boolean $baseUrlIsFile;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Url[] invoke() {
                void var2_2;
                int size$iv = SourceResolver.access$getRawSources$p(this.this$0).size();
                Url[] result$iv = new Url[size$iv];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    void it;
                    Url url;
                    void i$iv;
                    void var5_5 = i$iv;
                    void var9_8 = i$iv++;
                    Url[] urlArray = result$iv;
                    boolean bl = false;
                    urlArray[var9_8] = url = SourceResolverKt.canonicalizeUrl((String)SourceResolver.access$getRawSources$p(this.this$0).get((int)it), this.$baseUrl, this.$trimFileScheme, this.$baseUrlIsFile);
                }
                return var2_2;
            }
            {
                this.this$0 = sourceResolver;
                this.$baseUrl = url;
                this.$trimFileScheme = bl;
                this.$baseUrlIsFile = bl2;
                super(0);
            }
        }));
        this.canonicalizedUrlToSourceIndex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ObjectIntHashMap<Url>>(this){
            final /* synthetic */ SourceResolver this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ObjectIntHashMap<Url> invoke() {
                ObjectIntHashMap objectIntHashMap;
                ObjectIntHashMap it = objectIntHashMap = SystemInfo.isFileSystemCaseSensitive ? new ObjectIntHashMap(SourceResolver.access$getRawSources$p(this.this$0).size()) : new ObjectIntHashMap(SourceResolver.access$getRawSources$p(this.this$0).size(), Urls.INSTANCE.getCaseInsensitiveUrlHashingStrategy());
                boolean bl = false;
                int n = 0;
                int n2 = ((Collection)SourceResolver.access$getRawSources$p(this.this$0)).size();
                while (n < n2) {
                    void i;
                    it.put((Object)this.this$0.getCanonicalizedUrls()[i], (int)i);
                    ++i;
                }
                return objectIntHashMap;
            }
            {
                this.this$0 = sourceResolver;
                super(0);
            }
        }));
    }

    public /* synthetic */ SourceResolver(List list2, boolean bl, Url url, List list3, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        this(list2, bl, url, list3, bl2);
    }

    public static final /* synthetic */ List access$getRawSources$p(SourceResolver $this) {
        return $this.rawSources;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceResolver$Companion;", "", "()V", "isAbsolute", "", "path", "", "intellij.platform.scriptDebugger.backend"})
    public static final class Companion {
        public final boolean isAbsolute(@NotNull String path) {
            return StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) || SystemInfo.isWindows && path.length() > 2 && path.charAt(1) == ':';
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

