/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a*\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\t\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"canonicalizePath", "", "url", "baseUrl", "Lcom/intellij/util/Url;", "baseUrlIsFile", "", "canonicalizeUrl", "trimFileScheme", "doCanonicalize", "asLocalFileIfAbsoluteAndExists", "intellij.platform.scriptDebugger.backend"})
public final class SourceResolverKt {
    @NotNull
    public static final String canonicalizePath(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile) {
        CharSequence charSequence;
        String path = url;
        if (!FileUtil.isAbsolute((String)url) && !((charSequence = (CharSequence)url).length() == 0) && url.charAt(0) != '/') {
            String basePath = baseUrl.getPath();
            if (baseUrlIsFile) {
                int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)basePath, (char)'/', (int)0, (boolean)false, (int)6, null);
                StringBuilder pathBuilder = new StringBuilder();
                if (lastSlashIndex == -1) {
                    pathBuilder.append('/');
                } else {
                    pathBuilder.append(basePath, 0, lastSlashIndex + 1);
                }
                path = pathBuilder.append(url).toString();
            } else {
                path = basePath + '/' + url;
            }
        }
        return FileUtil.toCanonicalPath((String)path, (char)'/');
    }

    @NotNull
    public static final Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl, boolean trimFileScheme, boolean baseUrlIsFile) {
        if (trimFileScheme && StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2, null)) {
            String string = VfsUtilCore.toIdeaUrl((String)url, (boolean)true);
            int n = "file://".length();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return Urls.newLocalFileUrl(FileUtil.toCanonicalPath((String)string3, (char)'/'));
        }
        if (baseUrl == null || StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"data:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"blob:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"javascript:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"webpack:", (boolean)false, (int)2, null)) {
            Url url2 = Urls.parseEncoded(url);
            if (url2 == null) {
                url2 = Urls.newUri(null, url);
            }
            return url2;
        }
        return SourceResolverKt.doCanonicalize(url, baseUrl, baseUrlIsFile, true);
    }

    @NotNull
    public static /* synthetic */ Url canonicalizeUrl$default(String string, Url url, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return SourceResolverKt.canonicalizeUrl(string, url, bl, bl2);
    }

    @NotNull
    public static final Url doCanonicalize(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile, boolean asLocalFileIfAbsoluteAndExists) {
        String string;
        String string2;
        String path = SourceResolverKt.canonicalizePath(url, baseUrl, baseUrlIsFile);
        if (baseUrl.getScheme() == null && baseUrl.isInLocalFileSystem() || asLocalFileIfAbsoluteAndExists && SourceResolver.Companion.isAbsolute(path) && new File(path).exists()) {
            return Urls.newLocalFileUrl(path);
        }
        if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            Url url2 = Urls.parse(path, true);
            if (url2 == null) {
                url2 = Urls.newUnparsable(path);
            }
            return url2;
        }
        char[] cArray = new char[]{'?'};
        boolean bl = false;
        int n = 2;
        List split = StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)bl, (int)n, (int)2, null);
        String string3 = baseUrl.getScheme();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        if ((string2 = baseUrl.getAuthority()) == null) {
            Intrinsics.throwNpe();
        }
        String string4 = (String)split.get(0);
        if (split.size() > 1) {
            char c = '?';
            String string5 = (String)split.get(1);
            String string6 = string4;
            String string7 = string2;
            String string8 = string3;
            String string9 = String.valueOf(c) + string5;
            string3 = string8;
            string2 = string7;
            string4 = string6;
            string = string9;
        } else {
            string = null;
        }
        return Urls.newUrl(string3, string2, string4, string);
    }
}

