/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.idea.StartupUtil;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BuiltinWebServerAccess;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.net.NetUtils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLConnection;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.SubServer;

public class BuiltInServerManagerImpl
extends BuiltInServerManager
implements BaseComponent {
    private static final Logger LOG = Logger.getInstance(BuiltInServerManager.class);
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            return new NotificationGroup("Built-in Server", NotificationDisplayType.STICKY_BALLOON, true);
        }
    };
    @NonNls
    public static final String PROPERTY_RPC_PORT = "rpc.port";
    private static final int PORTS_COUNT = 20;
    private final AtomicBoolean started = new AtomicBoolean(false);
    @Nullable
    private BuiltInServer server;

    public int getPort() {
        return this.server == null ? BuiltInServerManagerImpl.getDefaultPort() : this.server.getPort();
    }

    public BuiltInServerManager waitForStart() {
        Future<?> serverStartFuture = this.startServerInPooledThread();
        if (serverStartFuture != null) {
            LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
            try {
                serverStartFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return this;
    }

    private static int getDefaultPort() {
        if (System.getProperty(PROPERTY_RPC_PORT) == null) {
            return ApplicationManager.getApplication().isUnitTestMode() ? 64463 : 63342;
        }
        return Integer.parseInt(System.getProperty(PROPERTY_RPC_PORT));
    }

    public void initComponent() {
        this.startServerInPooledThread();
    }

    private Future<?> startServerInPooledThread() {
        if (!this.started.compareAndSet(false, true)) {
            return null;
        }
        return ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                BuiltInServer mainServer = StartupUtil.getServer();
                this.server = mainServer == null || mainServer.getEventLoopGroup() instanceof OioEventLoopGroup ? BuiltInServer.start(1, BuiltInServerManagerImpl.getDefaultPort(), 20, false, null) : BuiltInServer.start(mainServer.getEventLoopGroup(), false, BuiltInServerManagerImpl.getDefaultPort(), 20, true, null);
                BuiltInServerManagerImpl.bindCustomPorts(this.server);
            }
            catch (Throwable e) {
                LOG.info(e);
                ((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification("Cannot start internal HTTP server. Git integration, JavaScript debugger and LiveEdit may operate with errors. Please check your firewall settings and restart " + ApplicationNamesInfo.getInstance().getFullProductName(), NotificationType.ERROR).notify(null);
                return;
            }
            LOG.info("built-in server started, port " + this.server.getPort());
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this.server);
        });
    }

    @Nullable
    public Disposable getServerDisposable() {
        return this.server;
    }

    @NotNull
    public EventLoopGroup getEventLoopGroup() {
        this.waitForStart();
        assert (this.server != null);
        return this.server.getEventLoopGroup();
    }

    public boolean isOnBuiltInWebServer(@Nullable Url url) {
        return url != null && !StringUtil.isEmpty((String)url.getAuthority()) && BuiltInServerManagerImpl.isOnBuiltInWebServerByAuthority(url.getAuthority());
    }

    public Url addAuthToken(@NotNull Url url) {
        try {
            String prefix = "/" + BuiltinWebServerAccess.getUserAuthenticationToken();
            if (!url.getPath().startsWith(prefix)) {
                return Urls.newUrl(Objects.requireNonNull(url.getScheme()), Objects.requireNonNull(url.getAuthority()), prefix + url.getPath(), url.getParameters());
            }
        }
        catch (IOException e) {
            LOG.warn(String.format("Unable to get User authentication token for launching url '%s'", url), (Throwable)e);
        }
        return url;
    }

    public void configureRequestToWebServer(@NotNull URLConnection connection) {
        connection.setRequestProperty("x-ijt", BuiltInWebServerKt.acquireToken());
    }

    private static void bindCustomPorts(@NotNull BuiltInServer server) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        for (CustomPortServerManager customPortServerManager : (CustomPortServerManager[])CustomPortServerManager.EP_NAME.getExtensions()) {
            try {
                new SubServer(customPortServerManager, server).bind(customPortServerManager.getPort());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    public static boolean isOnBuiltInWebServerByAuthority(@NotNull String authority) {
        int portIndex = authority.indexOf(58);
        if (portIndex < 0 || portIndex == authority.length() - 1) {
            return false;
        }
        int port = StringUtil.parseInt((String)authority.substring(portIndex + 1), (int)-1);
        if (port == -1) {
            return false;
        }
        BuiltInServerOptions options = BuiltInServerOptions.getInstance();
        int idePort = BuiltInServerManager.getInstance().getPort();
        if (options.builtInServerPort != port && idePort != port) {
            return false;
        }
        String host = authority.substring(0, portIndex);
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            return inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() || options.builtInServerAvailableExternally && idePort != port && NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (IOException e) {
            return false;
        }
    }
}

