/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide.script;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;
import org.jetbrains.ide.script.IdeScriptException;

class Jsr223IdeScriptEngineManagerImpl
extends IdeScriptEngineManager {
    private static final Logger LOG = Logger.getInstance(IdeScriptEngineManager.class);
    private final Future<ScriptEngineManager> myManagerFuture = PooledThreadExecutor.INSTANCE.submit(() -> {
        long start2 = System.currentTimeMillis();
        try {
            ScriptEngineManager scriptEngineManager = (ScriptEngineManager)ClassLoaderUtil.runWithClassLoader((ClassLoader)AllPluginsLoader.INSTANCE, () -> new ScriptEngineManager());
            return scriptEngineManager;
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.info(ScriptEngineManager.class.getName() + " initialized in " + (end - start2) + " ms");
        }
    });

    Jsr223IdeScriptEngineManagerImpl() {
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        return ContainerUtil.map(this.getScriptEngineManager().getEngineFactories(), factory -> factory.getLanguageName());
    }

    @Override
    @NotNull
    public List<String> getFileExtensions(@Nullable String language) {
        ArrayList extensions = ContainerUtil.newArrayList();
        List<ScriptEngineFactory> factories = this.getScriptEngineManager().getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            if (language != null && !factory.getLanguageName().equals(language)) continue;
            extensions.addAll(factory.getExtensions());
        }
        return extensions;
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineForLanguage(@NotNull String language, @Nullable ClassLoader loader) {
        ClassLoader l = (ClassLoader)ObjectUtils.notNull((Object)loader, (Object)AllPluginsLoader.INSTANCE);
        return (IdeScriptEngine)ClassLoaderUtil.runWithClassLoader((ClassLoader)l, () -> Jsr223IdeScriptEngineManagerImpl.createIdeScriptEngine(this.getScriptEngineManager().getEngineByName(language)));
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineForFileExtension(@NotNull String extension, @Nullable ClassLoader loader) {
        ClassLoader l = (ClassLoader)ObjectUtils.notNull((Object)loader, (Object)AllPluginsLoader.INSTANCE);
        return (IdeScriptEngine)ClassLoaderUtil.runWithClassLoader((ClassLoader)l, () -> Jsr223IdeScriptEngineManagerImpl.createIdeScriptEngine(this.getScriptEngineManager().getEngineByExtension(extension)));
    }

    @Override
    public boolean isInitialized() {
        return this.myManagerFuture.isDone();
    }

    @NotNull
    private ScriptEngineManager getScriptEngineManager() {
        ScriptEngineManager manager = null;
        try {
            manager = this.myManagerFuture.get();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return (ScriptEngineManager)ObjectUtils.assertNotNull((Object)manager);
    }

    @Nullable
    private static IdeScriptEngine createIdeScriptEngine(@Nullable ScriptEngine engine) {
        return engine == null ? null : Jsr223IdeScriptEngineManagerImpl.redirectOutputToLog(new Jsr223IdeScriptEngine(engine));
    }

    private static IdeScriptEngine redirectOutputToLog(IdeScriptEngine engine) {
        class Log
        extends Writer {
            final boolean error;

            Log(boolean error) {
                this.error = error;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                while (len > 0 && Character.isWhitespace(cbuf[off + len - 1])) {
                    --len;
                }
                if (len == 0) {
                    return;
                }
                String s = new String(cbuf, off, len);
                if (this.error) {
                    LOG.warn(s);
                } else {
                    LOG.info(s);
                }
            }
        }
        engine.setStdOut(new Log(false));
        engine.setStdErr(new Log(true));
        return engine;
    }

    static class AllPluginsLoader
    extends ClassLoader {
        static final AllPluginsLoader INSTANCE = new AllPluginsLoader();
        final ConcurrentMap<Long, ClassLoader> myLuckyGuess = ContainerUtil.newConcurrentMap();

        AllPluginsLoader() {
            super(null);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            int p0 = name.indexOf("$");
            boolean hasBase = p0 > 0;
            int p1 = hasBase ? name.indexOf("$", p0 + 1) : -1;
            String base = hasBase ? name.substring(0, Math.max(p0, p1)) : name;
            long hash = StringHash.calc((String)base);
            Class<?> c = null;
            ClassLoader guess1 = (ClassLoader)this.myLuckyGuess.get(hash);
            ClassLoader guess2 = (ClassLoader)this.myLuckyGuess.get(0L);
            for (ClassLoader loader : JBIterable.of((Object[])new ClassLoader[]{guess1, guess2})) {
                if (loader == this) {
                    throw new ClassNotFoundException(name);
                }
                if (loader == null) continue;
                try {
                    c = loader.loadClass(name);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (c == null) {
                for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                    ClassLoader l = descriptor.getPluginClassLoader();
                    if (l == null || l == guess1 || l == guess2) continue;
                    try {
                        if (hasBase) {
                            l.loadClass(base);
                            this.myLuckyGuess.putIfAbsent(hash, l);
                        }
                        try {
                            c = l.loadClass(name);
                            this.myLuckyGuess.putIfAbsent(hash, l);
                            this.myLuckyGuess.put(0L, l);
                        }
                        catch (ClassNotFoundException e) {
                            if (hasBase || name.startsWith("java.")) break;
                            if (!name.startsWith("groovy.")) continue;
                        }
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (c != null) {
                return c;
            }
            this.myLuckyGuess.putIfAbsent(hash, this);
            throw new ClassNotFoundException(name);
        }

        private static boolean isAllowedPluginResource(String name) {
            return "META-INF/services/javax.script.ScriptEngineFactory".equals(name);
        }

        @Override
        protected URL findResource(String name) {
            if (AllPluginsLoader.isAllowedPluginResource(name)) {
                for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                    URL url;
                    ClassLoader l = descriptor.getPluginClassLoader();
                    URL uRL = url = l == null ? null : l.getResource(name);
                    if (url == null) continue;
                    return url;
                }
            }
            return this.getClass().getClassLoader().getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            if (AllPluginsLoader.isAllowedPluginResource(name)) {
                LinkedHashSet result2 = null;
                for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                    Enumeration<URL> urls;
                    ClassLoader l = descriptor.getPluginClassLoader();
                    Enumeration<URL> enumeration = urls = l == null ? null : l.getResources(name);
                    if (urls == null || !urls.hasMoreElements()) continue;
                    if (result2 == null) {
                        result2 = ContainerUtil.newLinkedHashSet();
                    }
                    ContainerUtil.addAll((Collection)result2, urls);
                }
                if (result2 != null) {
                    return Collections.enumeration(result2);
                }
            }
            return this.getClass().getClassLoader().getResources(name);
        }

        @NotNull
        public List<URL> getUrls() {
            return JBIterable.of((Object[])PluginManagerCore.getPlugins()).map(PluginDescriptor::getPluginClassLoader).unique().flatMap(o -> {
                try {
                    return (List)o.getClass().getMethod("getUrls", new Class[0]).invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }).unique().toList();
        }
    }

    static class Jsr223IdeScriptEngine
    implements IdeScriptEngine {
        private final ScriptEngine myEngine;
        private final ClassLoader myLoader;

        Jsr223IdeScriptEngine(ScriptEngine engine) {
            this.myEngine = engine;
            this.myLoader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public Object getBinding(@NotNull String name) {
            return this.myEngine.get(name);
        }

        @Override
        public void setBinding(@NotNull String name, Object value) {
            this.myEngine.put(name, value);
        }

        @Override
        @NotNull
        public Writer getStdOut() {
            return this.myEngine.getContext().getWriter();
        }

        @Override
        public void setStdOut(@NotNull Writer writer) {
            this.myEngine.getContext().setWriter(writer);
        }

        @Override
        @NotNull
        public Writer getStdErr() {
            return this.myEngine.getContext().getErrorWriter();
        }

        @Override
        public void setStdErr(@NotNull Writer writer) {
            this.myEngine.getContext().setErrorWriter(writer);
        }

        @Override
        @NotNull
        public Reader getStdIn() {
            return this.myEngine.getContext().getReader();
        }

        @Override
        public void setStdIn(@NotNull Reader reader) {
            this.myEngine.getContext().setReader(reader);
        }

        @Override
        @NotNull
        public String getLanguage() {
            return this.myEngine.getFactory().getLanguageName();
        }

        @Override
        @NotNull
        public List<String> getFileExtensions() {
            return this.myEngine.getFactory().getExtensions();
        }

        @Override
        public Object eval(final @NotNull String script) throws IdeScriptException {
            return ClassLoaderUtil.runWithClassLoader((ClassLoader)this.myLoader, (ThrowableComputable)new ThrowableComputable<Object, IdeScriptException>(){

                public Object compute() throws IdeScriptException {
                    try {
                        return myEngine.eval(script);
                    }
                    catch (Throwable ex) {
                        while (ex instanceof ScriptException && ex.getCause() != null) {
                            ex = ex.getCause();
                        }
                        throw new IdeScriptException(ex);
                    }
                }
            });
        }
    }
}

