/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.NettyKt;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.DelegatingHttpRequestHandler;
import org.jetbrains.io.PortUnificationServerHandler;

public class BuiltInServer
implements Disposable {
    private static final int[] FORBIDDEN_PORTS = new int[]{6953, 6969, 6970};
    private final EventLoopGroup eventLoopGroup;
    private final int port;
    private final ChannelRegistrar channelRegistrar;

    private BuiltInServer(@NotNull EventLoopGroup eventLoopGroup, int port, @NotNull ChannelRegistrar channelRegistrar) {
        this.eventLoopGroup = eventLoopGroup;
        this.port = port;
        this.channelRegistrar = channelRegistrar;
    }

    @NotNull
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return !this.channelRegistrar.isEmpty();
    }

    public void dispose() {
        this.channelRegistrar.close();
        Logger.getInstance(BuiltInServer.class).info("web server stopped");
    }

    @NotNull
    public static BuiltInServer start(int workerCount, int firstPort, int portsCount, boolean tryAnyPort, @Nullable NotNullProducer<? extends ChannelHandler> handler2) throws Exception {
        return BuiltInServer.start((EventLoopGroup)NettyKt.MultiThreadEventLoopGroup(workerCount, new BuiltInServerThreadFactory()), true, firstPort, portsCount, tryAnyPort, handler2);
    }

    @NotNull
    public static BuiltInServer startNioOrOio(int workerCount, int firstPort, int portsCount, boolean tryAnyPort, @Nullable NotNullProducer<? extends ChannelHandler> handler2) throws Exception {
        MultithreadEventLoopGroup loopGroup;
        BuiltInServerThreadFactory threadFactory = new BuiltInServerThreadFactory();
        try {
            loopGroup = NettyKt.MultiThreadEventLoopGroup(workerCount, threadFactory);
        }
        catch (IllegalStateException e) {
            Logger.getInstance(BuiltInServer.class).warn((Throwable)e);
            loopGroup = new OioEventLoopGroup(1, (ThreadFactory)threadFactory);
        }
        return BuiltInServer.start((EventLoopGroup)loopGroup, true, firstPort, portsCount, tryAnyPort, handler2);
    }

    @NotNull
    public static BuiltInServer start(@NotNull EventLoopGroup eventLoopGroup, boolean isEventLoopGroupOwner, int firstPort, int portsCount, boolean tryAnyPort, @Nullable NotNullProducer<? extends ChannelHandler> handler2) throws Exception {
        ChannelRegistrar channelRegistrar = new ChannelRegistrar();
        ServerBootstrap bootstrap = NettyKt.serverBootstrap(eventLoopGroup);
        BuiltInServer.configureChildHandler(bootstrap, channelRegistrar, handler2);
        int port = BuiltInServer.bind(firstPort, portsCount, tryAnyPort, bootstrap, channelRegistrar, isEventLoopGroupOwner);
        return new BuiltInServer(eventLoopGroup, port, channelRegistrar);
    }

    static void configureChildHandler(@NotNull ServerBootstrap bootstrap, final @NotNull ChannelRegistrar channelRegistrar, final @Nullable NotNullProducer<? extends ChannelHandler> channelHandler) {
        final PortUnificationServerHandler portUnificationServerHandler = channelHandler == null ? new PortUnificationServerHandler() : null;
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(@NotNull Channel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{channelRegistrar, channelHandler == null ? portUnificationServerHandler : (ChannelHandler)channelHandler.produce()});
            }
        });
    }

    private static int bind(int firstPort, int portsCount, boolean tryAnyPort, @NotNull ServerBootstrap bootstrap, @NotNull ChannelRegistrar channelRegistrar, boolean isEventLoopGroupOwner) throws Exception {
        InetAddress address = InetAddress.getLoopbackAddress();
        for (int i = 0; i < portsCount; ++i) {
            int port = firstPort + i;
            if (ArrayUtil.indexOf((int[])FORBIDDEN_PORTS, (int)i) >= 0) continue;
            ChannelFuture future2 = bootstrap.bind(address, port).awaitUninterruptibly();
            if (future2.isSuccess()) {
                channelRegistrar.setServerChannel(future2.channel(), isEventLoopGroupOwner);
                return port;
            }
            if (tryAnyPort || i != portsCount - 1) continue;
            ExceptionUtil.rethrowAll((Throwable)future2.cause());
        }
        Logger.getInstance(BuiltInServer.class).info("We cannot bind to our default range, so, try to bind to any free port");
        ChannelFuture future3 = bootstrap.bind(address, 0).awaitUninterruptibly();
        if (future3.isSuccess()) {
            channelRegistrar.setServerChannel(future3.channel(), isEventLoopGroupOwner);
            return ((InetSocketAddress)future3.channel().localAddress()).getPort();
        }
        ExceptionUtil.rethrowAll((Throwable)future3.cause());
        return -1;
    }

    public static void replaceDefaultHandler(@NotNull ChannelHandlerContext context, @NotNull ChannelHandler channelHandler) {
        context.pipeline().replace(DelegatingHttpRequestHandler.class, "replacedDefaultHandler", channelHandler);
    }

    static {
        if (SystemProperties.getBooleanProperty((String)"io.netty.random.id", (boolean)true)) {
            System.setProperty("io.netty.machineId", "28:f0:76:ff:fe:16:65:0e");
            System.setProperty("io.netty.processId", Integer.toString(new Random().nextInt(65535)));
            System.setProperty("io.netty.serviceThreadPrefix", "Netty ");
        }
    }

    private static class BuiltInServerThreadFactory
    implements ThreadFactory {
        private final AtomicInteger counter = new AtomicInteger();

        private BuiltInServerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Netty Builtin Server " + this.counter.incrementAndGet());
        }
    }
}

