/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.google.common.base.Strings;
import com.intellij.ide.ui.ProductIcons;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Base64;
import com.intellij.util.BuiltinWebServerAccess;
import com.intellij.util.io.NettyKt;
import com.intellij.util.ui.UIUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.Attribute;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.DelegatingHttpRequestHandlerBase;
import org.jetbrains.io.DelegatingHttpRequestHandlerKt;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@ChannelHandler.Sharable
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/io/DelegatingHttpRequestHandler;", "Lorg/jetbrains/io/DelegatingHttpRequestHandlerBase;", "()V", "authenticateAndUpdateUrlIfNeeded", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "authenticateOnUrlAndUpdateUrl", "expectedToken", "", "exceptionCaught", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "cause", "", "getTokenFromAuthorization", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "intellij.platform.ide.impl"})
public final class DelegatingHttpRequestHandler
extends DelegatingHttpRequestHandlerBase {
    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean process(@NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) {
        void urlDecoder2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = urlDecoder;
        if (!this.authenticateAndUpdateUrlIfNeeded(request)) {
            String product = ApplicationInfoEx.getInstance().getVersionName();
            HttpHeaders headers = (HttpHeaders)new DefaultHttpHeaders();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Basic realm=\"%s\"";
            Object[] objectArray = new Object[]{product};
            String string2 = HttpHeaderNames.WWW_AUTHENTICATE.toString();
            HttpHeaders httpHeaders = headers;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string3;
            httpHeaders.add(string2, (Object)string4);
            Responses.send(HttpResponseStatus.UNAUTHORIZED, context.channel(), (HttpRequest)request, null, headers);
            return true;
        }
        urlDecoder2.element = new QueryStringDecoder(request.uri());
        Function1<HttpRequestHandler, Boolean> checkAndProcess$ = new Function1<HttpRequestHandler, Boolean>(request, (Ref.ObjectRef)urlDecoder2, context){
            final /* synthetic */ FullHttpRequest $request;
            final /* synthetic */ Ref.ObjectRef $urlDecoder;
            final /* synthetic */ ChannelHandlerContext $context;

            public final boolean invoke(@NotNull HttpRequestHandler $receiver) {
                return $receiver.isSupported(this.$request) && !NettyKt.isWriteFromBrowserWithoutOrigin((HttpRequest)this.$request) && $receiver.isAccessible((HttpRequest)this.$request) && $receiver.process((QueryStringDecoder)this.$urlDecoder.element, this.$request, this.$context);
            }
            {
                this.$request = fullHttpRequest;
                this.$urlDecoder = objectRef;
                this.$context = channelHandlerContext;
                super(1);
            }
        };
        Attribute prevHandlerAttribute = context.channel().attr(DelegatingHttpRequestHandlerKt.access$getPREV_HANDLER$p());
        HttpRequestHandler connectedHandler = (HttpRequestHandler)prevHandlerAttribute.get();
        if (connectedHandler != null) {
            if (checkAndProcess$.invoke(connectedHandler)) {
                return true;
            }
            prevHandlerAttribute.set(null);
        }
        for (HttpRequestHandler handler2 : HttpRequestHandler.Companion.getEP_NAME().getExtensionList()) {
            try {
                if (!checkAndProcess$.invoke(handler2)) continue;
                prevHandlerAttribute.set((Object)handler2);
                return true;
            }
            catch (Throwable e) {
                Logger.getInstance(BuiltInServer.class).error(e);
            }
        }
        if (Intrinsics.areEqual((Object)((QueryStringDecoder)urlDecoder2.element).path(), (Object)"/favicon.ico")) {
            Icon icon = ProductIcons.getInstance().getProductIcon();
            BufferedImage image = UIUtil.createImage((int)icon.getIconWidth(), (int)icon.getIconHeight(), (int)2);
            icon.paintIcon(null, image.getGraphics(), 0, 0);
            byte[] icoBytes = Imaging.writeImageToBytes((BufferedImage)image, (ImageFormat)((ImageFormat)ImageFormats.ICO), null);
            Responses.send$default(Responses.addNoCache((HttpResponse)Responses.response(FileResponses.INSTANCE.getContentType(((QueryStringDecoder)urlDecoder2.element).path()), Unpooled.wrappedBuffer((byte[])icoBytes))), context.channel(), (HttpRequest)request, null, 4, null);
            return true;
        }
        return false;
    }

    private final boolean authenticateAndUpdateUrlIfNeeded(FullHttpRequest request) {
        if (Intrinsics.areEqual((Object)request.uri(), (Object)"/favicon.ico")) {
            return true;
        }
        String expectedToken = null;
        try {
            expectedToken = BuiltinWebServerAccess.getUserAuthenticationToken();
        }
        catch (IOException e) {
            DelegatingHttpRequestHandlerKt.access$getLOG$p().error("Unable to read user authentication token", (Throwable)e);
            return false;
        }
        String receivedToken = this.getTokenFromAuthorization(request);
        if (receivedToken != null) {
            return Intrinsics.areEqual((Object)expectedToken, (Object)receivedToken);
        }
        return this.authenticateOnUrlAndUpdateUrl(request, expectedToken);
    }

    private final boolean authenticateOnUrlAndUpdateUrl(FullHttpRequest request, String expectedToken) {
        String prefix;
        String uri = request.uri();
        if (StringsKt.startsWith$default((String)uri, (String)(prefix = '/' + expectedToken + '/'), (boolean)false, (int)2, null)) {
            String string = uri;
            int n = prefix.length() - 1;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            uri = string3;
            request.setUri(uri);
            return true;
        }
        return false;
    }

    private final String getTokenFromAuthorization(FullHttpRequest request) {
        List list2;
        Object[] objectArray;
        Collection $receiver$iv;
        String authorization = request.headers().get("Authorization");
        if (Strings.isNullOrEmpty((String)authorization)) {
            return null;
        }
        if (!StringsKt.startsWith$default((String)authorization, (String)"Basic ", (boolean)false, (int)2, null) || authorization.length() < 7) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Invalid authorization header '%s', unexpected type.";
            Object[] objectArray2 = new Object[]{authorization};
            Logger logger = DelegatingHttpRequestHandlerKt.access$getLOG$p();
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            logger.warn(string3);
            return null;
        }
        String string = authorization;
        int n = 6;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String base64 = string5;
        String decoded = null;
        try {
            byte[] byArray = Base64.decode((String)base64);
            decoded = new String(byArray, Charsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string6 = "Invalid authorization header '%s', bad base64 encoding.";
            Object[] objectArray3 = new Object[]{authorization};
            Logger logger = DelegatingHttpRequestHandlerKt.access$getLOG$p();
            String string7 = String.format(string6, Arrays.copyOf(objectArray3, objectArray3.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
            String string8 = string7;
            logger.warn(string8);
            return null;
        }
        Object object = decoded;
        String string9 = ":";
        string9 = new Regex(string9);
        int n2 = 0;
        object = string9.split((CharSequence)object, n2);
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                objectArray = (Object[])it;
                if (objectArray.length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        $receiver$iv = list2;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Object thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] parts = stringArray;
        if (parts.length != 2) {
            $receiver$iv = StringCompanionObject.INSTANCE;
            thisCollection$iv = "Invalid authorization header '%s', bad username/password pair.";
            Object[] objectArray4 = new Object[]{authorization};
            Logger logger = DelegatingHttpRequestHandlerKt.access$getLOG$p();
            String string10 = String.format((String)thisCollection$iv, Arrays.copyOf(objectArray4, objectArray4.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"java.lang.String.format(format, *args)");
            String string11 = string10;
            logger.warn(string11);
            return null;
        }
        String username = parts[0];
        String password = parts[1];
        if (Intrinsics.areEqual((Object)"_token_", (Object)username) ^ true) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string12 = "Invalid authorization header '%s'";
            objectArray = new Object[]{authorization};
            Logger logger = DelegatingHttpRequestHandlerKt.access$getLOG$p();
            String string13 = String.format(string12, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"java.lang.String.format(format, *args)");
            String string14 = string13;
            logger.warn(string14);
            return null;
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        try {
            context.channel().attr(DelegatingHttpRequestHandlerKt.access$getPREV_HANDLER$p()).set(null);
        }
        finally {
            super.exceptionCaught(context, cause);
        }
    }
}

