/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.PathUtilRt;
import io.netty.channel.Channel;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.FileResponsesKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ6\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000e2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/io/FileResponses;", "", "()V", "checkCache", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "lastModified", "", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "getContentType", "", "path", "prepareSend", "Lio/netty/handler/codec/http/HttpResponse;", "filename", "sendFile", "", "file", "Ljava/nio/file/Path;", "intellij.platform.ide.impl"})
public final class FileResponses {
    public static final FileResponses INSTANCE;

    @NotNull
    public final String getContentType(@NotNull String path) {
        String string;
        block3: {
            block2: {
                String string2;
                string = PathUtilRt.getFileExtension((String)path);
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = (String)FileResponsesKt.access$getFileExtToMimeType$p().get((Object)it);
                if (string != null) break block3;
            }
            string = "application/octet-stream";
        }
        return string;
    }

    @JvmOverloads
    public final boolean checkCache(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @Nullable HttpHeaders extraHeaders) {
        Long ifModified = request.headers().getTimeMillis((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
        if (ifModified != null && ifModified >= lastModified) {
            Responses.send$default(HttpResponseStatus.NOT_MODIFIED, channel, request, null, extraHeaders, 4, null);
            return true;
        }
        return false;
    }

    @JvmOverloads
    public static /* synthetic */ boolean checkCache$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, long l, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        return fileResponses.checkCache(httpRequest, channel, l, httpHeaders);
    }

    @JvmOverloads
    public final boolean checkCache(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified) {
        return FileResponses.checkCache$default(this, request, channel, lastModified, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final HttpResponse prepareSend(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @NotNull String filename, @Nullable HttpHeaders extraHeaders) {
        if (this.checkCache(request, channel, lastModified, extraHeaders)) {
            return null;
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.getContentType(filename));
        Responses.addCommonHeaders((HttpResponse)response);
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, must-revalidate");
        response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(lastModified));
        if (extraHeaders != null) {
            response.headers().add(extraHeaders);
        }
        return (HttpResponse)response;
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ HttpResponse prepareSend$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, long l, String string, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 0x10) != 0) {
            httpHeaders = null;
        }
        return fileResponses.prepareSend(httpRequest, channel, l, string, httpHeaders);
    }

    @JvmOverloads
    @Nullable
    public final HttpResponse prepareSend(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @NotNull String filename) {
        return FileResponses.prepareSend$default(this, request, channel, lastModified, filename, null, 16, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendFile(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull Path file2, @Nullable HttpHeaders extraHeaders) {
        HttpResponse httpResponse = this.prepareSend(request, channel, Files.getLastModifiedTime(file2, new LinkOption[0]).toMillis(), ((Object)file2.getFileName()).toString(), extraHeaders);
        if (httpResponse == null) {
            return;
        }
        HttpResponse response = httpResponse;
        boolean isKeepAlive = Responses.addKeepAliveIfNeed(response, request);
        boolean fileWillBeClosed = false;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file2.toFile(), "r");
        }
        catch (FileNotFoundException ignored) {
            Responses.send$default(HttpResponseStatus.NOT_FOUND, channel, request, null, null, 12, null);
            return;
        }
        try {
            long fileLength = raf.length();
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)fileLength);
            channel.write((Object)response);
            if (request.method() != HttpMethod.HEAD) {
                if (channel.pipeline().get(SslHandler.class) == null) {
                    channel.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength));
                } else {
                    channel.write((Object)new ChunkedFile(raf));
                }
            }
            fileWillBeClosed = true;
        }
        catch (Throwable throwable) {
            raf.close();
            throw throwable;
        }
        FileResponsesKt.flushChunkedResponse(channel, isKeepAlive);
    }

    public static /* synthetic */ void sendFile$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, Path path, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        fileResponses.sendFile(httpRequest, channel, path, httpHeaders);
    }

    private FileResponses() {
    }

    static {
        FileResponses fileResponses;
        INSTANCE = fileResponses = new FileResponses();
    }
}

