/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;

public class JsonUtil {
    private static final String[] REPLACEMENT_CHARS = new String[128];

    public static void escape(@NotNull CharSequence value, @NotNull StringBuilder sb) {
        int length = value.length();
        sb.ensureCapacity(sb.length() + length + 2);
        sb.append('\"');
        int last = 0;
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = value.charAt(i);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                sb.append(value, last, i);
            }
            sb.append(replacement);
            last = i + 1;
        }
        if (last < length) {
            sb.append(value, last, length);
        }
        sb.append('\"');
    }

    public static void escape(@NotNull CharSequence value, @NotNull ByteBuf buffer) {
        int length = value.length();
        buffer.ensureWritable(length * 2);
        buffer.writeByte(34);
        int last = 0;
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = value.charAt(i);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                ByteBufUtilEx.writeUtf8(buffer, value, last, i);
            }
            ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)replacement);
            last = i + 1;
        }
        if (last < length) {
            ByteBufUtilEx.writeUtf8(buffer, value, last, length);
        }
        buffer.writeByte(34);
    }

    @NotNull
    public static <T> List<T> nextList(@NotNull JsonReaderEx reader) {
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return Collections.emptyList();
        }
        SmartList list2 = new SmartList();
        JsonUtil.readListBody(reader, list2);
        reader.endArray();
        return list2;
    }

    @NotNull
    public static Object[] nextArray(@NotNull JsonReaderEx reader) {
        List list2 = JsonUtil.nextList(reader);
        return ArrayUtil.toObjectArray(list2);
    }

    @NotNull
    public static Map<String, Object> nextObject(@NotNull JsonReaderEx reader) {
        THashMap map2 = new THashMap();
        reader.beginObject();
        while (reader.hasNext()) {
            map2.put(reader.nextName(), JsonUtil.nextAny(reader));
        }
        reader.endObject();
        return map2;
    }

    @Nullable
    public static Object nextAny(JsonReaderEx reader) {
        switch (reader.peek()) {
            case BEGIN_ARRAY: {
                return JsonUtil.nextList(reader);
            }
            case BEGIN_OBJECT: {
                return JsonUtil.nextObject(reader);
            }
            case STRING: {
                return reader.nextString();
            }
            case NUMBER: {
                return reader.nextDouble();
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case NULL: {
                reader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public static <T> void readListBody(JsonReaderEx reader, List<T> list2) {
        do {
            list2.add(JsonUtil.nextAny(reader));
        } while (reader.hasNext());
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonUtil.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JsonUtil.REPLACEMENT_CHARS[34] = "\\\"";
        JsonUtil.REPLACEMENT_CHARS[92] = "\\\\";
        JsonUtil.REPLACEMENT_CHARS[9] = "\\t";
        JsonUtil.REPLACEMENT_CHARS[8] = "\\b";
        JsonUtil.REPLACEMENT_CHARS[10] = "\\n";
        JsonUtil.REPLACEMENT_CHARS[13] = "\\r";
        JsonUtil.REPLACEMENT_CHARS[12] = "\\f";
    }
}

